/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.dw.ioc;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.ws.filter.AllowRequestWithoutDomainInUriFilter;
import io.corbel.lib.ws.filter.CharsetResponseFilter;
import io.corbel.lib.ws.filter.HeadersQueryParamsFilter;
import io.corbel.lib.ws.filter.NoRedirectResponseFilter;
import io.corbel.lib.ws.filter.ProxyLocationResponseRewriteFilter;
import io.corbel.lib.ws.filter.QueryParamsNotAllowedFilter;
import io.corbel.lib.ws.filter.RequestIdFilter;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class CommonFiltersIoc {
    @Autowired
    private Environment env;

    @Bean
    public CharsetResponseFilter getCharsetResponseFilter() {
        return new CharsetResponseFilter((Boolean)this.env.getProperty("filter.charset.enabled", Boolean.class, (Object)true));
    }

    @Bean
    public NoRedirectResponseFilter getRedirectResponseFilter() {
        return new NoRedirectResponseFilter((Boolean)this.env.getProperty("filter.noRedirect.enabled", Boolean.class, (Object)true));
    }

    @Bean
    public ProxyLocationResponseRewriteFilter getProxyLocationResponseRewriteFilter() {
        return new ProxyLocationResponseRewriteFilter((Boolean)this.env.getProperty("filter.proxyLocationResponseRewrite.enabled", Boolean.class, (Object)true));
    }

    @Bean
    public AllowRequestWithoutDomainInUriFilter getAllowRequestWithoutDomainInUriFilter(TokenParser tokenParser) {
        return new AllowRequestWithoutDomainInUriFilter((Boolean)this.env.getProperty("filter.allowRequestWithoutDomainInUri.enabled", Boolean.class, (Object)false), tokenParser, (String)this.env.getProperty("auth.unAuthenticatedPath", String.class), (String)this.env.getProperty("filter.allowRequestWithoutDomainInUri.endpoints", String.class, (Object)""));
    }

    @Bean
    public HeadersQueryParamsFilter getHeadersQueryParmamsFilter(ObjectMapper objectMapper) {
        return new HeadersQueryParamsFilter((Boolean)this.env.getProperty("filter.headersQueryParams.enabled", Boolean.class, (Object)false), objectMapper);
    }

    @Bean
    public QueryParamsNotAllowedFilter getStrictQueryParamsFilter() {
        return new QueryParamsNotAllowedFilter((Boolean)this.env.getProperty("filter.queryParamsNotAllowedFilter.enabled", Boolean.class, (Object)false), (List)this.env.getProperty("filter.queryParamsNotAllowedFilter.methods", List.class, Collections.emptyList()));
    }

    @Bean
    public RequestIdFilter getRequestIdFilter() {
        return new RequestIdFilter();
    }
}

