/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.encoding;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=3)
public class MatrixEncodingRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MatrixEncodingRequestFilter.class);
    private final Pattern matrixPattern;

    public MatrixEncodingRequestFilter(String matrixPattern) {
        this.matrixPattern = Pattern.compile(matrixPattern);
        LOG.info("Creating matrix encoding filter for path pattern {}", (Object)matrixPattern);
    }

    public void filter(ContainerRequestContext request) {
        URI path = request.getUriInfo().getAbsolutePath();
        Matcher matcher = this.matrixPattern.matcher(path.toASCIIString());
        if (matcher.matches()) {
            String encodedMatrix = matcher.group(2).replaceAll("/", "%2F");
            String encodedRequestUri = matcher.replaceFirst("$1" + encodedMatrix);
            request.setRequestUri(request.getUriInfo().getBaseUri(), URI.create(encodedRequestUri));
        }
    }
}

