/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.filter;

import io.corbel.lib.ws.filter.OptionalContainerResponseFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;

public class CharsetResponseFilter
extends OptionalContainerResponseFilter {
    private static final String CHARSET_UTF_8 = "UTF-8";

    public CharsetResponseFilter(boolean enabled) {
        super(enabled);
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType != null) {
            MediaType contentMediaType = mediaType.getParameters().containsKey("charset") ? mediaType : mediaType.withCharset(CHARSET_UTF_8);
            response.getHeaders().putSingle((Object)"Content-Type", (Object)contentMediaType);
        }
    }
}

