/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.filter.OptionalContainerRequestFilter;
import io.corbel.lib.ws.model.Error;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=1)
public class HeadersQueryParamsFilter
extends OptionalContainerRequestFilter {
    private static final String HEADER_KEY = "headers";
    private final ObjectMapper objectMapper;
    private final TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
    private static final Logger LOG = LoggerFactory.getLogger(HeadersQueryParamsFilter.class);

    public HeadersQueryParamsFilter(boolean enabled, ObjectMapper objectMapper) {
        super(enabled);
        this.objectMapper = objectMapper;
    }

    public void filter(ContainerRequestContext request) {
        String headerQueryParameters = (String)request.getUriInfo().getQueryParameters().getFirst((Object)HEADER_KEY);
        if (null != headerQueryParameters) {
            try {
                HashMap queryParamHeaders = (HashMap)this.objectMapper.readValue(headerQueryParameters, this.typeRef);
                for (String key : queryParamHeaders.keySet()) {
                    try {
                        request.getHeaders().putSingle((Object)key, (Object)URLDecoder.decode((String)queryParamHeaders.get(key), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ignored) {
                        LOG.error("Cannot decode query param value: " + (String)queryParamHeaders.get(key));
                    }
                }
            }
            catch (IOException e) {
                throw new WebApplicationException(ErrorResponseFactory.getInstance().badRequest(new Error("bad_request", "invalid query parameter format: headers")));
            }
        }
    }
}

