/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.filter;

import io.corbel.lib.ws.auth.AuthorizationInfo;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationResponseFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(InformationResponseFilter.class);

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        String authorizationMsg = this.getAuthorizationLog(containerRequestContext);
        LOG.info("Request {} {} {} result: {}, location: {}, length: {} {}", new Object[]{containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getAbsolutePath(), containerRequestContext.getMediaType(), containerResponseContext.getStatus(), containerResponseContext.getLocation(), containerResponseContext.getLength(), authorizationMsg});
    }

    private String getAuthorizationLog(ContainerRequestContext containerRequestContext) {
        Object property = containerRequestContext.getProperty("AuthorizationInfo");
        if (property != null) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)property;
            return ", from domain: " + authorizationInfo.getDomainId() + ", client: " + authorizationInfo.getClientId() + ", user: " + authorizationInfo.getUserId();
        }
        return "";
    }
}

