/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class GsonMessageReaderWriterProvider
implements MessageBodyReader<JsonElement>,
MessageBodyWriter<JsonElement> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.isJsonType(mediaType)) {
            return JsonElement.class.isAssignableFrom(type);
        }
        return false;
    }

    public long getSize(JsonElement t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.toString().length();
    }

    public JsonElement readFrom(Class<JsonElement> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            return null;
        }
        JsonParser parser = new JsonParser();
        try {
            JsonElement element = parser.parse(ReaderWriter.readFromAsString((InputStream)entityStream, (MediaType)mediaType));
            return element.isJsonNull() ? null : this.assertType(element, type);
        }
        catch (JsonParseException e) {
            throw new ConstraintViolationException("Malformed JSON:" + e.getMessage(), Collections.emptySet());
        }
    }

    private JsonElement assertType(JsonElement element, Class<JsonElement> type) {
        if (type.isAssignableFrom(element.getClass())) {
            return element;
        }
        throw new ConstraintViolationException("Malformed JSON: Expecting " + type + " but received " + element.getClass(), Collections.emptySet());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.isJsonType(mediaType)) {
            return JsonElement.class.isAssignableFrom(type);
        }
        return false;
    }

    public void writeTo(JsonElement t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (t != null) {
            ReaderWriter.writeToAsString((String)t.toString(), (OutputStream)entityStream, (MediaType)mediaType);
        }
    }

    protected boolean isJsonType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json");
        }
        return true;
    }
}

