/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.queries;

import io.corbel.lib.queries.exception.InvalidParameterException;
import io.corbel.lib.queries.jaxrs.QueryParameters;
import io.corbel.lib.queries.parser.QueryParametersParser;
import io.corbel.lib.ws.SpringJerseyProvider;
import io.corbel.lib.ws.annotation.Rest;
import io.corbel.lib.ws.api.error.ErrorMessage;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.model.Error;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public class QueryParametersProvider
implements SpringJerseyProvider {
    public static final String API_PAGE_SIZE = "api:pageSize";
    public static final String API_PAGE = "api:page";
    public static final String API_SORT = "api:sort";
    public static final String API_QUERY = "api:query";
    public static final String API_CONDITION = "api:condition";
    public static final String API_SEARCH = "api:search";
    public static final String API_INDEX_FIELDS_ONLY = "api:indexFieldsOnly";
    public static final String API_AGGREGATION = "api:aggregation";
    private static int defaultPageSize;
    private static int maxPageSize;
    private static QueryParametersParser queryParametersParser;

    public QueryParametersProvider(int defaultPageSize, int maxPageSize, QueryParametersParser queryParametersParser) {
        QueryParametersProvider.defaultPageSize = defaultPageSize;
        QueryParametersProvider.maxPageSize = maxPageSize;
        QueryParametersProvider.queryParametersParser = queryParametersParser;
    }

    @Override
    public org.glassfish.hk2.utilities.Binder getBinder() {
        return new Binder();
    }

    @Provider
    public static class QueryParametersFactoryProvider
    extends AbstractValueFactoryProvider {
        @Inject
        protected QueryParametersFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
            super(mpep, locator, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        }

        protected Factory<?> createValueFactory(Parameter parameter) {
            if (parameter.getRawType().equals(QueryParameters.class) && parameter.getAnnotation(Rest.class) != null) {
                return new QueryParametersFactory();
            }
            return null;
        }
    }

    public static class QueryParametersFactory
    extends AbstractContainerRequestValueFactory<QueryParameters> {
        public QueryParameters provide() {
            MultivaluedMap params = this.getContainerRequestBind().getUriInfo().getQueryParameters();
            try {
                return queryParametersParser.createQueryParameters(this.getIntegerParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_PAGE).orElse(0).intValue(), this.getIntegerParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_PAGE_SIZE).orElse(defaultPageSize).intValue(), maxPageSize, this.getStringParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_SORT), this.getListStringParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_QUERY), this.getListStringParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_CONDITION), this.getStringParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_AGGREGATION), this.getStringParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_SEARCH), this.getBooleanParam((MultivaluedMap<String, String>)params, QueryParametersProvider.API_INDEX_FIELDS_ONLY));
            }
            catch (InvalidParameterException e) {
                throw this.toRequestException(e);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException(this.badRequestResponse(this.error(e)));
            }
        }

        private WebApplicationException toRequestException(InvalidParameterException e) {
            switch (e.getParameter()) {
                case AGGREGATION: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_aggregation", ErrorMessage.INVALID_AGGREGATION.getMessage(e.getValue(), e.getMessage()))));
                }
                case PAGE: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_page", ErrorMessage.INVALID_PAGE.getMessage(e.getValue()))));
                }
                case PAGE_SIZE: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_page_size", ErrorMessage.INVALID_PAGE_SIZE.getMessage(e.getValue(), maxPageSize))));
                }
                case QUERY: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_query", ErrorMessage.INVALID_QUERY.getMessage(e.getValue(), e.getMessage()))));
                }
                case SORT: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_sort", ErrorMessage.INVALID_SORT.getMessage(e.getValue(), e.getMessage()))));
                }
                case SEARCH: {
                    return new WebApplicationException(this.badRequestResponse(new Error("invalid_search", ErrorMessage.INVALID_SEARCH.getMessage(e.getValue(), e.getMessage()))));
                }
            }
            return new WebApplicationException(ErrorResponseFactory.getInstance().badRequest());
        }

        private Error error(Exception e) {
            return new Error("bad_request", e.getMessage());
        }

        private Response badRequestResponse(Error error) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
        }

        private Optional<Integer> getIntegerParam(MultivaluedMap<String, String> params, String key) {
            return params.containsKey((Object)key) ? Optional.of(Integer.valueOf((String)((List)params.get((Object)key)).get(0))) : Optional.empty();
        }

        private Optional<String> getStringParam(MultivaluedMap<String, String> params, String key) {
            return params.containsKey((Object)key) ? Optional.of(((List)params.get((Object)key)).get(0)) : Optional.empty();
        }

        private boolean getBooleanParam(MultivaluedMap<String, String> params, String key) {
            return params.containsKey((Object)key) && Boolean.valueOf((String)((List)params.get((Object)key)).get(0)) != false;
        }

        private Optional<List<String>> getListStringParam(MultivaluedMap<String, String> params, String key) {
            return params.containsKey((Object)key) ? Optional.of(params.get((Object)key)) : Optional.empty();
        }

        public ContainerRequest getContainerRequestBind() {
            return super.getContainerRequest();
        }
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(QueryParametersFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(QueryParametersInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Rest>>(){}).in(Singleton.class);
        }
    }

    public static class QueryParametersInjectionResolver
    extends ParamInjectionResolver<Rest> {
        public QueryParametersInjectionResolver() {
            super(QueryParametersFactoryProvider.class);
        }
    }
}

