/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.cli.console;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import io.corbel.lib.cli.console.GroovyShellException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;

public class GroovyShell {
    private static final String SEPARATOR_BAR = "-----------------------------------------------------------";
    public static final String OUT_KEY = "out";
    private final InputStream in;
    private final OutputStream out;
    private final PrintStream writer;
    private final Binding binding;
    private final String welcomeMessage;

    public GroovyShell(InputStream in, OutputStream out, Binding binding) {
        this(in, out, binding, null);
    }

    public GroovyShell(InputStream in, OutputStream out, Binding binding, String welcomeMessage) {
        this.in = in;
        this.out = out;
        this.binding = binding;
        this.welcomeMessage = welcomeMessage;
        this.writer = new PrintStream(out);
    }

    public void run() throws GroovyShellException {
        try {
            Groovysh shell = this.createShell();
            shell.run((String)null);
        }
        catch (Exception e) {
            throw new GroovyShellException(e);
        }
    }

    private Groovysh createShell() {
        if (this.welcomeMessage != null) {
            this.writer.println(SEPARATOR_BAR);
            this.writer.println(this.welcomeMessage);
            this.writer.println(SEPARATOR_BAR);
        }
        this.binding.setVariable(OUT_KEY, (Object)this.out);
        CompilerConfiguration config = new CompilerConfiguration();
        GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader(), config);
        Groovysh shell = new Groovysh((ClassLoader)loader, this.binding, new IO(this.in, this.out, this.out));
        this.writer.flush();
        return shell;
    }

    public void runScripts(List<File> files) {
        Groovysh shell = this.createShell();
        try {
            for (File file : files) {
                if (!(file.exists() && file.canRead() && file.isFile())) {
                    throw new GroovyShellException("Unable to open script file: " + file);
                }
                shell.execute(":load " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new GroovyShellException(e);
        }
    }
}

