@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\org\bouncycastle\bcmail-jdk15on\1.52\bcmail-jdk15on-1.52.jar;"%REPO%"\org\bouncycastle\bcpkix-jdk15on\1.52\bcpkix-jdk15on-1.52.jar;"%REPO%"\org\bouncycastle\bcprov-jdk15on\1.52\bcprov-jdk15on-1.52.jar;"%REPO%"\io\corbel\lib\token\0.9.0\token-0.9.0.jar;"%REPO%"\io\corbel\lib\ws\0.20.0\ws-0.20.0.jar;"%REPO%"\io\corbel\lib\config\0.3.0\config-0.3.0.jar;"%REPO%"\io\corbel\lib\queries-api\0.14.0\queries-api-0.14.0.jar;"%REPO%"\io\corbel\lib\rabbitmq\0.9.0\rabbitmq-0.9.0.jar;"%REPO%"\org\springframework\amqp\spring-rabbit\1.4.5.RELEASE\spring-rabbit-1.4.5.RELEASE.jar;"%REPO%"\com\rabbitmq\amqp-client\3.5.1\amqp-client-3.5.1.jar;"%REPO%"\org\springframework\retry\spring-retry\1.1.2.RELEASE\spring-retry-1.1.2.RELEASE.jar;"%REPO%"\org\springframework\amqp\spring-amqp\1.4.5.RELEASE\spring-amqp-1.4.5.RELEASE.jar;"%REPO%"\org\springframework\spring-messaging\4.1.7.RELEASE\spring-messaging-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\spring-web\4.1.7.RELEASE\spring-web-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\spring-aop\4.1.7.RELEASE\spring-aop-4.1.7.RELEASE.jar;"%REPO%"\aopalliance\aopalliance\1.0\aopalliance-1.0.jar;"%REPO%"\org\springframework\spring-beans\4.1.7.RELEASE\spring-beans-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\spring-context\4.1.7.RELEASE\spring-context-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\spring-expression\4.1.7.RELEASE\spring-expression-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\data\spring-data-redis\1.4.1.RELEASE\spring-data-redis-1.4.1.RELEASE.jar;"%REPO%"\org\springframework\spring-tx\4.1.7.RELEASE\spring-tx-4.1.7.RELEASE.jar;"%REPO%"\org\springframework\spring-context-support\4.1.7.RELEASE\spring-context-support-4.1.7.RELEASE.jar;"%REPO%"\com\google\guava\guava\18.0\guava-18.0.jar;"%REPO%"\redis\clients\jedis\2.6.0\jedis-2.6.0.jar;"%REPO%"\org\apache\commons\commons-pool2\2.0\commons-pool2-2.0.jar;"%REPO%"\com\google\code\gson\gson\2.3\gson-2.3.jar;"%REPO%"\commons-codec\commons-codec\1.9\commons-codec-1.9.jar;"%REPO%"\com\fasterxml\jackson\datatype\jackson-datatype-jsr310\2.5.1\jackson-datatype-jsr310-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-databind\2.5.1\jackson-databind-2.5.1.jar;"%REPO%"\com\papertrailapp\logback-syslog4j\1.0.0\logback-syslog4j-1.0.0.jar;"%REPO%"\ch\qos\logback\logback-core\1.1.2\logback-core-1.1.2.jar;"%REPO%"\ch\qos\logback\logback-classic\1.1.2\logback-classic-1.1.2.jar;"%REPO%"\org\syslog4j\syslog4j\0.9.30\syslog4j-0.9.30.jar;"%REPO%"\com\fasterxml\jackson\module\jackson-module-scala_2.11\2.5.1\jackson-module-scala_2.11-2.5.1.jar;"%REPO%"\org\scala-lang\scala-library\2.11.4\scala-library-2.11.4.jar;"%REPO%"\org\scala-lang\scala-reflect\2.11.4\scala-reflect-2.11.4.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-core\2.5.1\jackson-core-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-annotations\2.5.1\jackson-annotations-2.5.1.jar;"%REPO%"\com\thoughtworks\paranamer\paranamer\2.6\paranamer-2.6.jar;"%REPO%"\io\corbel\lib\queries-mongo\0.14.0\queries-mongo-0.14.0.jar;"%REPO%"\com\fasterxml\jackson\datatype\jackson-datatype-jdk8\2.5.1\jackson-datatype-jdk8-2.5.1.jar;"%REPO%"\commons-beanutils\commons-beanutils\1.9.2\commons-beanutils-1.9.2.jar;"%REPO%"\commons-logging\commons-logging\1.1.1\commons-logging-1.1.1.jar;"%REPO%"\commons-collections\commons-collections\3.2.1\commons-collections-3.2.1.jar;"%REPO%"\io\corbel\lib\mongodb\0.7.0\mongodb-0.7.0.jar;"%REPO%"\org\springframework\data\spring-data-mongodb\1.6.1.RELEASE\spring-data-mongodb-1.6.1.RELEASE.jar;"%REPO%"\org\springframework\data\spring-data-commons\1.9.1.RELEASE\spring-data-commons-1.9.1.RELEASE.jar;"%REPO%"\org\mongodb\mongo-java-driver\2.12.3\mongo-java-driver-2.12.3.jar;"%REPO%"\org\slf4j\jcl-over-slf4j\1.7.7\jcl-over-slf4j-1.7.7.jar;"%REPO%"\joda-time\joda-time\2.8.1\joda-time-2.8.1.jar;"%REPO%"\io\corbel\lib\cli\0.4.0\cli-0.4.0.jar;"%REPO%"\me\bazhenov\groovy-shell\groovy-shell-server\1.3\groovy-shell-server-1.3.jar;"%REPO%"\org\codehaus\groovy\groovy-all\2.3.3\groovy-all-2.3.3.jar;"%REPO%"\jline\jline\2.11\jline-2.11.jar;"%REPO%"\org\fusesource\jansi\jansi\1.11\jansi-1.11.jar;"%REPO%"\io\corbel\rem-api\1.32.0\rem-api-1.32.0.jar;"%REPO%"\com\github\zafarkhaja\java-semver\0.9.0\java-semver-0.9.0.jar;"%REPO%"\io\corbel\events\1.27.0\events-1.27.0.jar;"%REPO%"\io\corbel\event-bus\1.27.1\event-bus-1.27.1.jar;"%REPO%"\io\dropwizard\dropwizard-core\0.8.1\dropwizard-core-0.8.1.jar;"%REPO%"\io\dropwizard\dropwizard-util\0.8.1\dropwizard-util-0.8.1.jar;"%REPO%"\com\google\code\findbugs\jsr305\3.0.0\jsr305-3.0.0.jar;"%REPO%"\io\dropwizard\dropwizard-jackson\0.8.1\dropwizard-jackson-0.8.1.jar;"%REPO%"\com\fasterxml\jackson\datatype\jackson-datatype-jdk7\2.5.1\jackson-datatype-jdk7-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\datatype\jackson-datatype-guava\2.5.1\jackson-datatype-guava-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\module\jackson-module-afterburner\2.5.1\jackson-module-afterburner-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\datatype\jackson-datatype-joda\2.5.1\jackson-datatype-joda-2.5.1.jar;"%REPO%"\io\dropwizard\dropwizard-validation\0.8.1\dropwizard-validation-0.8.1.jar;"%REPO%"\org\hibernate\hibernate-validator\5.1.3.Final\hibernate-validator-5.1.3.Final.jar;"%REPO%"\javax\validation\validation-api\1.1.0.Final\validation-api-1.1.0.Final.jar;"%REPO%"\org\jboss\logging\jboss-logging\3.1.3.GA\jboss-logging-3.1.3.GA.jar;"%REPO%"\com\fasterxml\classmate\1.0.0\classmate-1.0.0.jar;"%REPO%"\org\glassfish\javax.el\3.0.0\javax.el-3.0.0.jar;"%REPO%"\io\dropwizard\dropwizard-configuration\0.8.1\dropwizard-configuration-0.8.1.jar;"%REPO%"\com\fasterxml\jackson\dataformat\jackson-dataformat-yaml\2.5.1\jackson-dataformat-yaml-2.5.1.jar;"%REPO%"\org\yaml\snakeyaml\1.12\snakeyaml-1.12.jar;"%REPO%"\org\apache\commons\commons-lang3\3.3.2\commons-lang3-3.3.2.jar;"%REPO%"\io\dropwizard\dropwizard-logging\0.8.1\dropwizard-logging-0.8.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-logback\3.1.1\metrics-logback-3.1.1.jar;"%REPO%"\org\slf4j\jul-to-slf4j\1.7.10\jul-to-slf4j-1.7.10.jar;"%REPO%"\org\slf4j\log4j-over-slf4j\1.7.10\log4j-over-slf4j-1.7.10.jar;"%REPO%"\org\eclipse\jetty\jetty-util\9.2.9.v20150224\jetty-util-9.2.9.v20150224.jar;"%REPO%"\io\dropwizard\dropwizard-metrics\0.8.1\dropwizard-metrics-0.8.1.jar;"%REPO%"\io\dropwizard\dropwizard-jersey\0.8.1\dropwizard-jersey-0.8.1.jar;"%REPO%"\org\glassfish\jersey\core\jersey-server\2.17\jersey-server-2.17.jar;"%REPO%"\org\glassfish\jersey\core\jersey-common\2.17\jersey-common-2.17.jar;"%REPO%"\org\glassfish\jersey\bundles\repackaged\jersey-guava\2.17\jersey-guava-2.17.jar;"%REPO%"\org\glassfish\hk2\osgi-resource-locator\1.0.1\osgi-resource-locator-1.0.1.jar;"%REPO%"\org\glassfish\jersey\media\jersey-media-jaxb\2.17\jersey-media-jaxb-2.17.jar;"%REPO%"\javax\annotation\javax.annotation-api\1.2\javax.annotation-api-1.2.jar;"%REPO%"\org\glassfish\hk2\hk2-api\2.4.0-b10\hk2-api-2.4.0-b10.jar;"%REPO%"\org\glassfish\hk2\hk2-utils\2.4.0-b10\hk2-utils-2.4.0-b10.jar;"%REPO%"\org\glassfish\hk2\external\aopalliance-repackaged\2.4.0-b10\aopalliance-repackaged-2.4.0-b10.jar;"%REPO%"\org\glassfish\hk2\external\javax.inject\2.4.0-b10\javax.inject-2.4.0-b10.jar;"%REPO%"\org\glassfish\hk2\hk2-locator\2.4.0-b10\hk2-locator-2.4.0-b10.jar;"%REPO%"\org\javassist\javassist\3.18.1-GA\javassist-3.18.1-GA.jar;"%REPO%"\org\glassfish\jersey\ext\jersey-metainf-services\2.17\jersey-metainf-services-2.17.jar;"%REPO%"\io\dropwizard\metrics\metrics-jersey2\3.1.1\metrics-jersey2-3.1.1.jar;"%REPO%"\com\fasterxml\jackson\jaxrs\jackson-jaxrs-json-provider\2.5.1\jackson-jaxrs-json-provider-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\jaxrs\jackson-jaxrs-base\2.5.1\jackson-jaxrs-base-2.5.1.jar;"%REPO%"\com\fasterxml\jackson\module\jackson-module-jaxb-annotations\2.5.1\jackson-module-jaxb-annotations-2.5.1.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-servlet\2.17\jersey-container-servlet-2.17.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-servlet-core\2.17\jersey-container-servlet-core-2.17.jar;"%REPO%"\org\eclipse\jetty\jetty-server\9.2.9.v20150224\jetty-server-9.2.9.v20150224.jar;"%REPO%"\javax\servlet\javax.servlet-api\3.1.0\javax.servlet-api-3.1.0.jar;"%REPO%"\org\eclipse\jetty\jetty-io\9.2.9.v20150224\jetty-io-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-webapp\9.2.9.v20150224\jetty-webapp-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-xml\9.2.9.v20150224\jetty-xml-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-continuation\9.2.9.v20150224\jetty-continuation-9.2.9.v20150224.jar;"%REPO%"\io\dropwizard\dropwizard-servlets\0.8.1\dropwizard-servlets-0.8.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-annotation\3.1.1\metrics-annotation-3.1.1.jar;"%REPO%"\io\dropwizard\dropwizard-jetty\0.8.1\dropwizard-jetty-0.8.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-jetty9\3.1.1\metrics-jetty9-3.1.1.jar;"%REPO%"\org\eclipse\jetty\jetty-servlet\9.2.9.v20150224\jetty-servlet-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-security\9.2.9.v20150224\jetty-security-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-servlets\9.2.9.v20150224\jetty-servlets-9.2.9.v20150224.jar;"%REPO%"\org\eclipse\jetty\jetty-http\9.2.9.v20150224\jetty-http-9.2.9.v20150224.jar;"%REPO%"\io\dropwizard\dropwizard-lifecycle\0.8.1\dropwizard-lifecycle-0.8.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-core\3.1.1\metrics-core-3.1.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-jvm\3.1.1\metrics-jvm-3.1.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-servlets\3.1.1\metrics-servlets-3.1.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-json\3.1.1\metrics-json-3.1.1.jar;"%REPO%"\io\dropwizard\metrics\metrics-healthchecks\3.1.1\metrics-healthchecks-3.1.1.jar;"%REPO%"\net\sourceforge\argparse4j\argparse4j\0.4.4\argparse4j-0.4.4.jar;"%REPO%"\org\eclipse\jetty\toolchain\setuid\jetty-setuid-java\1.0.2\jetty-setuid-java-1.0.2.jar;"%REPO%"\io\dropwizard\dropwizard-auth\0.8.1\dropwizard-auth-0.8.1.jar;"%REPO%"\org\glassfish\jersey\core\jersey-client\2.17\jersey-client-2.17.jar;"%REPO%"\commons-io\commons-io\2.4\commons-io-2.4.jar;"%REPO%"\javax\ws\rs\javax.ws.rs-api\2.0.1\javax.ws.rs-api-2.0.1.jar;"%REPO%"\org\slf4j\slf4j-api\1.7.7\slf4j-api-1.7.7.jar;"%REPO%"\org\springframework\spring-core\4.1.7.RELEASE\spring-core-4.1.7.RELEASE.jar;"%REPO%"\io\corbel\resources\1.32.0\resources-1.32.0.jar

set ENDORSED_DIR=plugins
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% -Dfile.encoding=UTF-8 -classpath %CLASSPATH% -Dapp.name="resources" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" io.corbel.resources.ResourcesRunner %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
