/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceAttributesBridge;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.exception.MultipleJsonApiLinksInformationException;
import io.crnk.core.exception.MultipleJsonApiMetaInformationException;
import io.crnk.core.exception.ResourceDuplicateIdException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResourceInformation {
    private final Class<?> resourceClass;
    private final ResourceField idField;
    private final ResourceAttributesBridge attributeFields;
    private final List<ResourceField> relationshipFields;
    private final ResourceField metaField;
    private final ResourceField linksField;
    private String resourceType;
    private ResourceInstanceBuilder<?> instanceBuilder;
    private TypeParser parser;
    private String superResourceType;
    private Map<String, ResourceField> fieldByJsonName = new HashMap<String, ResourceField>();
    private List<ResourceField> fields;

    public ResourceInformation(TypeParser parser, Class<?> resourceClass, String resourceType, String superResourceType, List<ResourceField> fields) {
        this(parser, resourceClass, resourceType, superResourceType, null, fields);
    }

    public ResourceInformation(TypeParser parser, Class<?> resourceClass, String resourceType, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields) {
        this.parser = parser;
        this.resourceClass = resourceClass;
        this.resourceType = resourceType;
        this.superResourceType = superResourceType;
        this.instanceBuilder = instanceBuilder;
        this.fields = fields;
        if (fields != null) {
            List<ResourceField> idFields = ResourceFieldType.ID.filter(fields);
            if (idFields.size() > 1) {
                throw new ResourceDuplicateIdException(resourceClass.getCanonicalName());
            }
            this.idField = idFields.isEmpty() ? null : idFields.get(0);
            this.attributeFields = new ResourceAttributesBridge(ResourceFieldType.ATTRIBUTE.filter(fields), resourceClass);
            this.relationshipFields = ResourceFieldType.RELATIONSHIP.filter(fields);
            this.metaField = ResourceInformation.getMetaField(resourceClass, fields);
            this.linksField = ResourceInformation.getLinksField(resourceClass, fields);
            for (ResourceField resourceField : fields) {
                resourceField.setResourceInformation(this);
                this.fieldByJsonName.put(resourceField.getJsonName(), resourceField);
            }
        } else {
            this.relationshipFields = Collections.emptyList();
            this.attributeFields = new ResourceAttributesBridge(Collections.emptyList(), resourceClass);
            this.metaField = null;
            this.linksField = null;
            this.idField = null;
        }
        if (this.instanceBuilder == null) {
            this.instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        }
    }

    private static <T> ResourceField getMetaField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> metaFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.META_INFORMATION) continue;
            metaFields.add(field);
        }
        if (metaFields.isEmpty()) {
            return null;
        }
        if (metaFields.size() > 1) {
            throw new MultipleJsonApiMetaInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)metaFields.get(0);
    }

    private static <T> ResourceField getLinksField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> linksFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.LINKS_INFORMATION) continue;
            linksFields.add(field);
        }
        if (linksFields.isEmpty()) {
            return null;
        }
        if (linksFields.size() > 1) {
            throw new MultipleJsonApiLinksInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)linksFields.get(0);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getSuperResourceType() {
        return this.superResourceType;
    }

    public ResourceInstanceBuilder<?> getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ResourceField getIdField() {
        return this.idField;
    }

    public ResourceAttributesBridge getAttributeFields() {
        return this.attributeFields;
    }

    public List<ResourceField> getRelationshipFields() {
        return this.relationshipFields;
    }

    public ResourceField findFieldByName(String name) {
        return this.fieldByJsonName.get(name);
    }

    public ResourceField findRelationshipFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP ? resourceField : null;
    }

    public ResourceField findAttributeFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.ATTRIBUTE ? resourceField : null;
    }

    public ResourceField getMetaField() {
        return this.metaField;
    }

    public ResourceField getLinksField() {
        return this.linksField;
    }

    public Set<String> getNotAttributeFields() {
        HashSet<String> notAttributeFields = new HashSet<String>();
        for (ResourceField relationshipField : this.relationshipFields) {
            notAttributeFields.add(relationshipField.getJsonName());
        }
        notAttributeFields.add(this.idField.getJsonName());
        if (this.metaField != null) {
            notAttributeFields.add(this.metaField.getUnderlyingName());
        }
        if (this.linksField != null) {
            notAttributeFields.add(this.linksField.getUnderlyingName());
        }
        return notAttributeFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInformation that = (ResourceInformation)o;
        return Objects.equals(this.resourceClass, that.resourceClass) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.idField, that.idField) && Objects.equals(this.attributeFields, that.attributeFields) && Objects.equals(this.relationshipFields, that.relationshipFields) && Objects.equals(this.metaField, that.metaField) && Objects.equals(this.linksField, that.linksField);
    }

    public int hashCode() {
        return Objects.hash(this.resourceClass, this.resourceType, this.idField, this.attributeFields, this.relationshipFields, this.metaField, this.linksField);
    }

    public String toIdString(Object id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public Serializable parseIdString(String id) {
        Class<?> idType = this.getIdField().getType();
        return this.parser.parse(id, idType);
    }

    public Object getId(Object resource) {
        return this.idField.getAccessor().getValue(resource);
    }

    public void setId(Object resource, Object id) {
        this.idField.getAccessor().setValue(resource, id);
    }

    @Deprecated
    public void verify(Object resource, Document requestDocument) {
    }

    public List<ResourceField> getFields() {
        return this.fields;
    }
}

