/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.information.resource.ResourceAttributesBridge;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.utils.Generics;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.properties.ResourceFieldImmutableWriteBehavior;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceUpsert
extends BaseController {
    protected final ResourceRegistry resourceRegistry;
    protected final ObjectMapper objectMapper;
    final TypeParser typeParser;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DocumentMapper documentMapper;
    private PropertiesProvider propertiesProvider;

    public ResourceUpsert(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper) {
        this.propertiesProvider = propertiesProvider;
        this.resourceRegistry = resourceRegistry;
        this.typeParser = typeParser;
        this.objectMapper = objectMapper;
        this.documentMapper = documentMapper;
    }

    private static boolean allTypesTheSame(Iterable<ResourceIdentifier> linkages) {
        String type = linkages.iterator().hasNext() ? linkages.iterator().next().getType() : null;
        for (ResourceIdentifier linkageData : linkages) {
            if (Objects.equals(type, linkageData.getType())) continue;
            return false;
        }
        return true;
    }

    protected Object newResource(ResourceInformation resourceInformation, Resource dataBody) {
        ResourceInstanceBuilder<?> builder = resourceInformation.getInstanceBuilder();
        return builder.buildResource(dataBody);
    }

    protected void setId(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        if (dataBody.getId() != null) {
            String id = dataBody.getId();
            Serializable castedId = resourceInformation.parseIdString(id);
            ResourceField idField = resourceInformation.getIdField();
            idField.getAccessor().setValue(instance, castedId);
        }
    }

    protected Set<String> getLoadedRelationshipNames(Resource resourceBody) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Relationship> entry : resourceBody.getRelationships().entrySet()) {
            if (entry.getValue() == null || entry.getValue().getData() == null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected void setAttributes(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        if (dataBody.getAttributes() != null) {
            ResourceAttributesBridge resourceAttributesBridge = resourceInformation.getAttributeFields();
            for (Map.Entry<String, JsonNode> entry : dataBody.getAttributes().entrySet()) {
                ResourceField field;
                String attributeName = entry.getKey();
                if (this.canModifyField(resourceInformation, attributeName, field = resourceInformation.findAttributeFieldByName(attributeName))) {
                    resourceAttributesBridge.setProperty(this.objectMapper, instance, entry.getValue(), entry.getKey());
                    continue;
                }
                this.handleImmutableField(resourceInformation, entry.getKey());
            }
        }
    }

    protected void saveRelations(QueryAdapter queryAdapter, Object savedResource, RegistryEntry registryEntry, Resource dataBody, RepositoryMethodParameterProvider parameterProvider) {
        if (dataBody.getRelationships() != null) {
            for (Map.Entry<String, Relationship> property : dataBody.getRelationships().entrySet()) {
                Relationship relationship = property.getValue();
                if (relationship == null || !relationship.getData().isPresent()) continue;
                Nullable<Object> data = relationship.getData();
                if (data instanceof Iterable) {
                    this.saveRelationsField(queryAdapter, savedResource, registryEntry, property, registryEntry.getResourceInformation(), parameterProvider);
                    continue;
                }
                this.saveRelationField(queryAdapter, savedResource, registryEntry, property, registryEntry.getResourceInformation(), parameterProvider);
            }
        }
    }

    private void saveRelationsField(QueryAdapter queryAdapter, Object savedResource, RegistryEntry registryEntry, Map.Entry<String, Iterable<ResourceIdentifier>> property, ResourceInformation resourceInformation, RepositoryMethodParameterProvider parameterProvider) {
        if (!ResourceUpsert.allTypesTheSame(property.getValue())) {
            throw new ResourceException("Not all types are the same for linkage: " + property.getKey());
        }
        String type = this.getLinkageType(property.getValue());
        RegistryEntry relationRegistryEntry = this.getRelationRegistryEntry(type);
        Class<?> relationshipIdClass = relationRegistryEntry.getResourceInformation().getIdField().getType();
        LinkedList castedRelationIds = new LinkedList();
        for (ResourceIdentifier linkageData : property.getValue()) {
            Object castedRelationshipId = this.typeParser.parse(linkageData.getId(), relationshipIdClass);
            castedRelationIds.add(castedRelationshipId);
        }
        Class<?> relationshipClass = relationRegistryEntry.getResourceInformation().getResourceClass();
        RelationshipRepositoryAdapter relationshipRepository = registryEntry.getRelationshipRepositoryForClass(relationshipClass, parameterProvider);
        ResourceField relationshipField = resourceInformation.findRelationshipFieldByName(property.getKey());
        if (this.canModifyField(resourceInformation, property.getKey(), relationshipField)) {
            relationshipRepository.setRelations(savedResource, castedRelationIds, relationshipField, queryAdapter);
        } else {
            this.handleImmutableField(resourceInformation, property.getKey());
        }
    }

    private void handleImmutableField(ResourceInformation resourceInformation, String fieldName) {
        ResourceFieldImmutableWriteBehavior behavior;
        String strBehavior = this.propertiesProvider.getProperty("crnk.config.resource.immutableWrite");
        ResourceFieldImmutableWriteBehavior resourceFieldImmutableWriteBehavior = behavior = strBehavior != null ? ResourceFieldImmutableWriteBehavior.valueOf(strBehavior) : ResourceFieldImmutableWriteBehavior.IGNORE;
        if (behavior != ResourceFieldImmutableWriteBehavior.IGNORE) {
            throw new BadRequestException("attribute '" + fieldName + "' is immutable");
        }
        this.logger.debug("attribute '{}' is immutable", (Object)fieldName);
    }

    protected abstract boolean canModifyField(ResourceInformation var1, String var2, ResourceField var3);

    protected String getLinkageType(Iterable<ResourceIdentifier> linkages) {
        return linkages.iterator().hasNext() ? linkages.iterator().next().getType() : null;
    }

    private void saveRelationField(QueryAdapter queryAdapter, Object savedResource, RegistryEntry registryEntry, Map.Entry<String, ResourceIdentifier> property, ResourceInformation resourceInformation, RepositoryMethodParameterProvider parameterProvider) {
        RegistryEntry relationRegistryEntry = this.getRelationRegistryEntry(property.getValue().getType());
        Class<?> relationshipIdClass = relationRegistryEntry.getResourceInformation().getIdField().getType();
        Object castedRelationshipId = this.typeParser.parse(property.getValue().getId(), relationshipIdClass);
        Class<?> relationshipClass = relationRegistryEntry.getResourceInformation().getResourceClass();
        RelationshipRepositoryAdapter relationshipRepository = registryEntry.getRelationshipRepositoryForClass(relationshipClass, parameterProvider);
        ResourceField relationshipField = resourceInformation.findRelationshipFieldByName(property.getKey());
        relationshipRepository.setRelation(savedResource, castedRelationshipId, relationshipField, queryAdapter);
    }

    private RegistryEntry getRelationRegistryEntry(String type) {
        RegistryEntry relationRegistryEntry = this.resourceRegistry.getEntry(type);
        if (relationRegistryEntry == null) {
            throw new ResourceNotFoundException(type);
        }
        return relationRegistryEntry;
    }

    Object buildNewResource(RegistryEntry registryEntry, Resource dataBody, String resourceName) {
        if (dataBody == null) {
            throw new ResourceException("No data field in the body.");
        }
        if (!resourceName.equals(dataBody.getType())) {
            throw new ResourceException(String.format("Inconsistent type definition between path and body: body type: %s, request type: %s", dataBody.getType(), resourceName));
        }
        try {
            return registryEntry.getResourceInformation().getResourceClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResourceException(String.format("couldn't create a new instance of %s", registryEntry.getResourceInformation().getResourceClass()));
        }
    }

    protected void setRelations(Object newResource, RegistryEntry registryEntry, Resource resource, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        if (resource.getRelationships() != null) {
            for (Map.Entry<String, Relationship> property : resource.getRelationships().entrySet()) {
                String propertyName = property.getKey();
                Relationship relationship = property.getValue();
                if (relationship == null) continue;
                ResourceInformation resourceInformation = registryEntry.getResourceInformation();
                ResourceField field = resourceInformation.findRelationshipFieldByName(propertyName);
                if (field == null) {
                    throw new ResourceException(String.format("Invalid relationship name: %s for %s", property.getKey(), resourceInformation.getResourceType()));
                }
                if (field.isCollection()) {
                    this.setRelationsField(newResource, registryEntry, property, queryAdapter, parameterProvider);
                    continue;
                }
                this.setRelationField(newResource, registryEntry, propertyName, relationship, queryAdapter, parameterProvider);
            }
        }
    }

    protected void setRelationsField(Object newResource, RegistryEntry registryEntry, Map.Entry<String, Relationship> property, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Relationship relationship = property.getValue();
        if (relationship.getData().isPresent()) {
            String propertyName = property.getKey();
            ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(propertyName);
            Class<?> relationshipFieldClass = Generics.getResourceClass(relationshipField.getGenericType(), relationshipField.getType());
            Class<?> idFieldType = null;
            LinkedList<Object> relationships = new LinkedList<Object>();
            boolean first = true;
            for (ResourceIdentifier resourceId : relationship.getCollectionData().get()) {
                RegistryEntry entry = this.resourceRegistry.findEntry(resourceId.getType(), relationshipFieldClass);
                idFieldType = entry.getResourceInformation().getIdField().getType();
                first = false;
                Object castedRelationshipId = this.typeParser.parse(resourceId.getId(), idFieldType);
                Object relationObject = this.fetchRelatedObject(entry, (Serializable)castedRelationshipId, parameterProvider, queryAdapter);
                relationships.add(relationObject);
            }
            PropertyUtils.setProperty(newResource, relationshipField.getUnderlyingName(), relationships);
        }
    }

    protected void setRelationField(Object newResource, RegistryEntry registryEntry, String relationshipName, Relationship relationship, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        if (relationship.getData().isPresent()) {
            Object relationObject;
            ResourceIdentifier relationshipId = (ResourceIdentifier)relationship.getData().get();
            ResourceField relationshipFieldByName = registryEntry.getResourceInformation().findRelationshipFieldByName(relationshipName);
            if (relationshipFieldByName == null) {
                throw new ResourceException(String.format("Invalid relationship name: %s", relationshipName));
            }
            if (relationshipId != null) {
                RegistryEntry entry = this.resourceRegistry.findEntry(relationshipId.getType(), relationshipFieldByName.getType());
                Class<?> idFieldType = entry.getResourceInformation().getIdField().getType();
                Object castedRelationshipId = this.typeParser.parse(relationshipId.getId(), idFieldType);
                relationObject = this.fetchRelatedObject(entry, (Serializable)castedRelationshipId, parameterProvider, queryAdapter);
            } else {
                relationObject = null;
            }
            relationshipFieldByName.getAccessor().setValue(newResource, relationObject);
        }
    }

    protected Object fetchRelatedObject(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        return entry.getResourceRepository(parameterProvider).findOne(relationId, queryAdapter).getEntity();
    }
}

