/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.CrnkMappableException;
import io.crnk.core.exception.ForbiddenException;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.exception.UnauthorizedException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrnkExceptionMapper
implements ExceptionMapper<CrnkMappableException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkExceptionMapper.class);

    @Override
    public ErrorResponse toErrorResponse(CrnkMappableException exception) {
        if (exception.getHttpStatus() >= 500 && exception.getHttpStatus() < 600) {
            LOGGER.error("failed to process request", (Throwable)exception);
        } else {
            LOGGER.warn("failed to process request", (Throwable)exception);
        }
        return ErrorResponse.builder().setStatus(exception.getHttpStatus()).setSingleErrorData(exception.getErrorData()).build();
    }

    @Override
    public CrnkMappableException fromErrorResponse(ErrorResponse errorResponse) {
        String message = this.getMessage(errorResponse);
        int httpStatus = errorResponse.getHttpStatus();
        if (httpStatus == 403) {
            return new ForbiddenException(message);
        }
        if (httpStatus == 401) {
            return new UnauthorizedException(message);
        }
        if (httpStatus == 404) {
            return new ResourceNotFoundException(message);
        }
        if (httpStatus == 400) {
            return new BadRequestException(message);
        }
        if (httpStatus == 500) {
            return new InternalServerErrorException(message);
        }
        throw new IllegalStateException(errorResponse.toString());
    }

    private String getMessage(ErrorResponse errorResponse) {
        Iterator<ErrorData> errors = errorResponse.getErrors().iterator();
        String message = null;
        if (errors.hasNext()) {
            ErrorData data = errors.next();
            message = data.getDetail();
        }
        return message;
    }

    @Override
    public boolean accepts(ErrorResponse errorResponse) {
        int httpStatus = errorResponse.getHttpStatus();
        return httpStatus == 404 || httpStatus == 400 || httpStatus == 403 || httpStatus == 401 || httpStatus == 500;
    }
}

