/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import io.crnk.core.exception.InternalException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AnnotatedMethodBuilder {
    private static final String CANNOT_FIND_PROPER_CONSTRUCTOR = "Couldn't find proper AnnotatedField constructor";

    public static AnnotatedMethod build(AnnotatedClass annotatedClass, Method method, AnnotationMap annotationMap, AnnotationMap[] paramAnnotations) {
        int n = 0;
        Constructor<?>[] constructorArray = AnnotatedMethod.class.getConstructors();
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            try {
                return AnnotatedMethodBuilder.buildAnnotatedField(annotatedClass, method, annotationMap, paramAnnotations, constructor);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InternalException("Exception while building " + AnnotatedMethod.class.getCanonicalName(), e);
            }
        }
        throw new InternalException(CANNOT_FIND_PROPER_CONSTRUCTOR);
    }

    private static AnnotatedMethod buildAnnotatedField(AnnotatedClass annotatedClass, Method method, AnnotationMap annotationMap, AnnotationMap[] paramAnnotations, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> firstParameterType = constructor.getParameterTypes()[0];
        if (firstParameterType == AnnotatedClass.class || "TypeResolutionContext".equals(firstParameterType.getSimpleName())) {
            return (AnnotatedMethod)constructor.newInstance(annotatedClass, method, annotationMap, paramAnnotations);
        }
        throw new InternalException(CANNOT_FIND_PROPER_CONSTRUCTOR);
    }
}

