/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldNameTransformer;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationBuilder;
import io.crnk.core.engine.information.resource.ResourceInformationBuilderContext;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.FieldOrderedComparator;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.exception.RepositoryAnnotationNotFoundException;
import io.crnk.core.exception.ResourceIdNotFoundException;
import io.crnk.core.resource.annotations.JsonApiField;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiIncludeByDefault;
import io.crnk.core.resource.annotations.JsonApiLinksInformation;
import io.crnk.core.resource.annotations.JsonApiLookupIncludeAutomatically;
import io.crnk.core.resource.annotations.JsonApiMetaInformation;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.JsonApiToMany;
import io.crnk.core.resource.annotations.JsonApiToOne;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.core.utils.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AnnotationResourceInformationBuilder
implements ResourceInformationBuilder {
    private final ResourceFieldNameTransformer resourceFieldNameTransformer;
    private ResourceInformationBuilderContext context;

    public AnnotationResourceInformationBuilder(ResourceFieldNameTransformer resourceFieldNameTransformer) {
        this.resourceFieldNameTransformer = resourceFieldNameTransformer;
    }

    public static String getResourceType(Type genericType, ResourceInformationBuilderContext context) {
        Class<?> rawType;
        Class<?> elementType = genericType;
        if (Iterable.class.isAssignableFrom(ClassUtils.getRawType(genericType))) {
            elementType = ClassUtils.getRawType(((ParameterizedType)((Object)genericType)).getActualTypeArguments()[0]);
        }
        return context.accept(rawType = ClassUtils.getRawType(elementType)) ? context.getResourceType(rawType) : null;
    }

    private static boolean hasDiscardedField(ResourceFieldWrapper fieldWrapper, List<ResourceFieldWrapper> resourceClassFields) {
        for (ResourceFieldWrapper resourceFieldWrapper : resourceClassFields) {
            if (!fieldWrapper.getResourceField().getUnderlyingName().equals(resourceFieldWrapper.getResourceField().getUnderlyingName())) continue;
            return true;
        }
        return false;
    }

    private static AnnotatedResourceField mergeAnnotations(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod, ResourceInformationBuilderContext context) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(fromField.getAnnotations());
        annotations.addAll(fromMethod.getAnnotations());
        Class<?> fieldType = AnnotationResourceInformationBuilder.mergeFieldType(fromField, fromMethod);
        Type fieldGenericType = AnnotationResourceInformationBuilder.mergeGenericType(fromField, fromMethod);
        String oppositeResourceType = fromField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP ? AnnotationResourceInformationBuilder.getResourceType(fieldGenericType, context) : null;
        boolean postable = fromField.getAccess().isPostable() && fromMethod.getAccess().isPostable();
        boolean patchable = fromField.getAccess().isPatchable() && fromMethod.getAccess().isPatchable();
        boolean sortable = fromField.getAccess().isSortable() && fromMethod.getAccess().isSortable();
        boolean filterable = fromField.getAccess().isFilterable() && fromMethod.getAccess().isFilterable();
        ResourceFieldAccess mergedAccess = new ResourceFieldAccess(postable, patchable, sortable, filterable);
        return new AnnotatedResourceField(fromField.getJsonName(), fromField.getUnderlyingName(), fieldType, fieldGenericType, oppositeResourceType, annotations, mergedAccess);
    }

    private static Class<?> mergeFieldType(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod) {
        if (AnnotationResourceInformationBuilder.hasJsonApiAnnotation(fromField.getAnnotations())) {
            return fromField.getType();
        }
        return fromMethod.getType();
    }

    private static Type mergeGenericType(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod) {
        if (AnnotationResourceInformationBuilder.hasJsonApiAnnotation(fromField.getAnnotations())) {
            return fromField.getGenericType();
        }
        return fromMethod.getGenericType();
    }

    private static boolean hasJsonApiAnnotation(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != JsonApiId.class && annotation.annotationType() != JsonApiRelation.class && annotation.annotationType() != JsonApiToOne.class && annotation.annotationType() != JsonApiField.class && annotation.annotationType() != JsonApiToMany.class && annotation.annotationType() != JsonApiMetaInformation.class && annotation.annotationType() != JsonApiLinksInformation.class) continue;
            return true;
        }
        return false;
    }

    public static ResourceFieldAccess getResourceFieldAccess(ResourceFieldType resourceFieldType, boolean hasSetter, Collection<Annotation> annotations) {
        boolean postable = hasSetter;
        boolean patchable = hasSetter && resourceFieldType != ResourceFieldType.ID;
        boolean sortable = true;
        boolean filterable = true;
        JsonApiField fieldAnnotation = AnnotatedResourceField.getFieldAnnotation(annotations);
        JsonProperty jsonProperty = AnnotatedResourceField.getJsonPropertyAnnotation(annotations);
        if (fieldAnnotation != null) {
            postable = fieldAnnotation.postable();
            patchable = fieldAnnotation.patchable();
            sortable = fieldAnnotation.sortable();
            filterable = fieldAnnotation.filterable();
        } else if (jsonProperty != null) {
            JsonProperty.Access access = jsonProperty.access();
            switch (access) {
                case READ_WRITE: {
                    postable = true;
                    patchable = true;
                    break;
                }
                case AUTO: {
                    break;
                }
                case READ_ONLY: {
                    postable = false;
                    patchable = false;
                    break;
                }
                case WRITE_ONLY: {
                    throw new IllegalStateException("WRITE_ONLY policy not (yet) supported");
                }
                default: {
                    throw new IllegalStateException("unknown access policy " + access);
                }
            }
        }
        return new ResourceFieldAccess(postable, patchable, sortable, filterable);
    }

    public static boolean hasSetter(Class<?> resourceClass, String underlyingName) {
        Field field = ClassUtils.findClassField(resourceClass, underlyingName);
        Class<?> type = PropertyUtils.getPropertyClass(resourceClass, underlyingName);
        Method setter = ClassUtils.findSetter(resourceClass, underlyingName, type);
        return setter != null || field != null && Modifier.isPublic(field.getModifiers());
    }

    @Override
    public boolean accept(Class<?> resourceClass) {
        return resourceClass.getAnnotation(JsonApiResource.class) != null;
    }

    @Override
    public ResourceInformation build(Class<?> resourceClass) {
        return this.build(resourceClass, false);
    }

    public ResourceInformation build(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        ResourceInformation information;
        List<ResourceField> resourceFields = this.getResourceFields(resourceClass);
        String resourceType = this.getResourceType(resourceClass, allowNonResourceBaseClass);
        Optional<JsonPropertyOrder> propertyOrder = ClassUtils.getAnnotation(resourceClass, JsonPropertyOrder.class);
        if (propertyOrder.isPresent()) {
            JsonPropertyOrder propertyOrderAnnotation = propertyOrder.get();
            Collections.sort(resourceFields, new FieldOrderedComparator(propertyOrderAnnotation.value(), propertyOrderAnnotation.alphabetic()));
        }
        DefaultResourceInstanceBuilder instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        Class<?> superclass = resourceClass.getSuperclass();
        String superResourceType = superclass != Object.class && this.context.accept(superclass) ? this.context.getResourceType(superclass) : null;
        if (!allowNonResourceBaseClass & (information = new ResourceInformation(this.context.getTypeParser(), resourceClass, resourceType, superResourceType, instanceBuilder, resourceFields)).getIdField() == null) {
            throw new ResourceIdNotFoundException(resourceClass.getCanonicalName());
        }
        return information;
    }

    @Override
    public String getResourceType(Class<?> resourceClass) {
        return this.getResourceType(resourceClass, false);
    }

    private String getResourceType(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = resourceClass.getAnnotations()) {
            if (!(annotation instanceof JsonApiResource)) continue;
            JsonApiResource apiResource = (JsonApiResource)annotation;
            return apiResource.type();
        }
        if (allowNonResourceBaseClass) {
            return null;
        }
        throw new RepositoryAnnotationNotFoundException(resourceClass.getName());
    }

    protected List<AnnotatedResourceField> getResourceFields(Class<?> resourceClass) {
        List<Field> classFields = ClassUtils.getClassFields(resourceClass);
        List<Method> classGetters = ClassUtils.getClassGetters(resourceClass);
        List<ResourceFieldWrapper> resourceClassFields = this.getFieldResourceFields(resourceClass, classFields);
        List<ResourceFieldWrapper> resourceGetterFields = this.getGetterResourceFields(resourceClass, classGetters);
        return this.getResourceFields(resourceClassFields, resourceGetterFields);
    }

    private List<ResourceFieldWrapper> getFieldResourceFields(Class<?> resourceClass, List<Field> classFields) {
        ArrayList<ResourceFieldWrapper> fieldWrappers = new ArrayList<ResourceFieldWrapper>(classFields.size());
        for (Field field : classFields) {
            String jsonName = this.resourceFieldNameTransformer.getName(field);
            String underlyingName = field.getName();
            fieldWrappers.add(this.getResourceField(resourceClass, field, underlyingName, jsonName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations())));
        }
        return fieldWrappers;
    }

    private List<ResourceFieldWrapper> getGetterResourceFields(Class<?> resourceClass, List<Method> classGetters) {
        ArrayList<ResourceFieldWrapper> fieldWrappers = new ArrayList<ResourceFieldWrapper>(classGetters.size());
        for (Method getter : classGetters) {
            String underlyingName = ClassUtils.getGetterFieldName(getter);
            if (underlyingName == null) continue;
            String jsonName = this.resourceFieldNameTransformer.getName(getter);
            fieldWrappers.add(this.getResourceField(resourceClass, getter, jsonName, underlyingName, getter.getReturnType(), getter.getGenericReturnType(), Arrays.asList(getter.getAnnotations())));
        }
        return fieldWrappers;
    }

    private ResourceFieldWrapper getResourceField(Class<?> resourceClass, Member member, String underlyingName, String jsonName, Class<?> type, Type genericType, List<Annotation> annotations) {
        ResourceFieldType resourceFieldType = AnnotatedResourceField.getResourceFieldType(annotations);
        String oppositeResourceType = resourceFieldType == ResourceFieldType.RELATIONSHIP ? AnnotationResourceInformationBuilder.getResourceType(genericType, this.context) : null;
        boolean hasSetter = AnnotationResourceInformationBuilder.hasSetter(resourceClass, underlyingName);
        ResourceFieldAccess access = AnnotationResourceInformationBuilder.getResourceFieldAccess(resourceFieldType, hasSetter, annotations);
        AnnotatedResourceField resourceField = new AnnotatedResourceField(jsonName, underlyingName, type, genericType, oppositeResourceType, annotations, access);
        if (Modifier.isTransient(member.getModifiers()) || Modifier.isStatic(member.getModifiers())) {
            return new ResourceFieldWrapper(resourceField, true);
        }
        return new ResourceFieldWrapper(resourceField, false);
    }

    private List<AnnotatedResourceField> getResourceFields(List<ResourceFieldWrapper> resourceClassFields, List<ResourceFieldWrapper> resourceGetterFields) {
        HashMap<String, Integer> resourceFieldPositions = new HashMap<String, Integer>();
        ArrayList<AnnotatedResourceField> resourceFields = new ArrayList<AnnotatedResourceField>();
        for (ResourceFieldWrapper fieldWrapper : resourceClassFields) {
            if (fieldWrapper.isDiscarded()) continue;
            resourceFieldPositions.put(fieldWrapper.getResourceField().getUnderlyingName(), resourceFields.size());
            resourceFields.add(fieldWrapper.getResourceField());
        }
        for (ResourceFieldWrapper fieldWrapper : resourceGetterFields) {
            if (fieldWrapper.isDiscarded()) continue;
            String originalName = fieldWrapper.getResourceField().getUnderlyingName();
            AnnotatedResourceField field = fieldWrapper.getResourceField();
            if (resourceFieldPositions.containsKey(originalName)) {
                int pos = (Integer)resourceFieldPositions.get(originalName);
                resourceFields.set(pos, AnnotationResourceInformationBuilder.mergeAnnotations((AnnotatedResourceField)resourceFields.get(pos), field, this.context));
                continue;
            }
            if (AnnotationResourceInformationBuilder.hasDiscardedField(fieldWrapper, resourceClassFields)) continue;
            resourceFieldPositions.put(originalName, resourceFields.size());
            resourceFields.add(field);
        }
        return this.discardIgnoredField(resourceFields);
    }

    private List<AnnotatedResourceField> discardIgnoredField(Collection<AnnotatedResourceField> resourceFieldValues) {
        LinkedList<AnnotatedResourceField> resourceFields = new LinkedList<AnnotatedResourceField>();
        for (AnnotatedResourceField resourceField : resourceFieldValues) {
            if (resourceField.isAnnotationPresent(JsonIgnore.class)) continue;
            resourceFields.add(resourceField);
        }
        return resourceFields;
    }

    @Override
    public void init(ResourceInformationBuilderContext context) {
        this.context = context;
    }

    public static class AnnotatedResourceField
    extends ResourceFieldImpl {
        private List<Annotation> annotations;

        public AnnotatedResourceField(String jsonName, String underlyingName, Class<?> type, Type genericType, String oppositeResourceType, List<Annotation> annotations, ResourceFieldAccess access) {
            super(jsonName, underlyingName, AnnotatedResourceField.getResourceFieldType(annotations), type, genericType, oppositeResourceType, AnnotatedResourceField.getOppositeName(annotations), AnnotatedResourceField.isLazy(annotations), AnnotatedResourceField.getIncludeByDefault(annotations), AnnotatedResourceField.getLookupIncludeBehavior(annotations), access);
            this.annotations = annotations;
        }

        private static String getOppositeName(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiToMany) {
                    return StringUtils.emptyToNull(((JsonApiToMany)annotation).opposite());
                }
                if (annotation instanceof JsonApiToOne) {
                    return StringUtils.emptyToNull(((JsonApiToOne)annotation).opposite());
                }
                if (!(annotation instanceof JsonApiRelation)) continue;
                return StringUtils.emptyToNull(((JsonApiRelation)annotation).opposite());
            }
            return null;
        }

        public static boolean getIncludeByDefault(Collection<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    JsonApiRelation jsonApiRelation = (JsonApiRelation)annotation;
                    return jsonApiRelation.serialize() == SerializeType.EAGER;
                }
                if (!(annotation instanceof JsonApiIncludeByDefault)) continue;
                return true;
            }
            return false;
        }

        public static JsonApiField getFieldAnnotation(Collection<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JsonApiField)) continue;
                return (JsonApiField)annotation;
            }
            return null;
        }

        public static JsonProperty getJsonPropertyAnnotation(Collection<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof JsonProperty)) continue;
                return (JsonProperty)annotation;
            }
            return null;
        }

        public static LookupIncludeBehavior getLookupIncludeBehavior(Collection<Annotation> annotations) {
            return AnnotatedResourceField.getLookupIncludeBehavior(annotations, LookupIncludeBehavior.NONE);
        }

        public static LookupIncludeBehavior getLookupIncludeBehavior(Collection<Annotation> annotations, LookupIncludeBehavior defaultBehavior) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    JsonApiRelation jsonApiRelation = (JsonApiRelation)annotation;
                    return jsonApiRelation.lookUp();
                }
                if (!(annotation instanceof JsonApiLookupIncludeAutomatically)) continue;
                JsonApiLookupIncludeAutomatically includeAnnotation = (JsonApiLookupIncludeAutomatically)annotation;
                if (includeAnnotation.overwrite()) {
                    return LookupIncludeBehavior.AUTOMATICALLY_ALWAYS;
                }
                return LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL;
            }
            return defaultBehavior;
        }

        public static boolean isLazy(List<Annotation> annotations) {
            return AnnotatedResourceField.isLazy(annotations, false);
        }

        public static boolean isLazy(Collection<Annotation> annotations, boolean defaultValue) {
            JsonApiRelation jsonApiRelation = null;
            JsonApiIncludeByDefault includeByDefaultAnnotation = null;
            JsonApiToMany toManyAnnotation = null;
            JsonApiToOne toOneAnnotation = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    jsonApiRelation = (JsonApiRelation)annotation;
                    break;
                }
                if (annotation.annotationType().equals(JsonApiIncludeByDefault.class)) {
                    includeByDefaultAnnotation = (JsonApiIncludeByDefault)annotation;
                }
                if (annotation.annotationType().equals(JsonApiToMany.class)) {
                    toManyAnnotation = (JsonApiToMany)annotation;
                }
                if (!annotation.annotationType().equals(JsonApiToOne.class)) continue;
                toOneAnnotation = (JsonApiToOne)annotation;
            }
            if (jsonApiRelation != null) {
                switch (jsonApiRelation.serialize()) {
                    case LAZY: {
                        return true;
                    }
                    case ONLY_ID: {
                        return false;
                    }
                    case EAGER: {
                        return false;
                    }
                }
                throw new UnsupportedOperationException("Unknown serialize type " + (Object)((Object)jsonApiRelation.serialize()));
            }
            if (includeByDefaultAnnotation != null) {
                return false;
            }
            if (toManyAnnotation != null) {
                return toManyAnnotation.lazy();
            }
            if (toOneAnnotation != null) {
                return toOneAnnotation.lazy();
            }
            return defaultValue;
        }

        public static ResourceFieldType getResourceFieldType(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiId) {
                    return ResourceFieldType.ID;
                }
                if (annotation instanceof JsonApiToOne || annotation instanceof JsonApiToMany || annotation instanceof JsonApiRelation) {
                    return ResourceFieldType.RELATIONSHIP;
                }
                if (annotation instanceof JsonApiMetaInformation) {
                    return ResourceFieldType.META_INFORMATION;
                }
                if (!(annotation instanceof JsonApiLinksInformation)) continue;
                return ResourceFieldType.LINKS_INFORMATION;
            }
            return ResourceFieldType.ATTRIBUTE;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<?> annotationClass) {
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationClass)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ResourceFieldWrapper {
        private AnnotatedResourceField resourceField;
        private boolean discarded;

        public ResourceFieldWrapper(AnnotatedResourceField resourceField, boolean discarded) {
            this.resourceField = resourceField;
            this.discarded = discarded;
        }

        public AnnotatedResourceField getResourceField() {
            return this.resourceField;
        }

        public boolean isDiscarded() {
            return this.discarded;
        }
    }
}

