/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.resource.ReflectionFieldAccessor;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ResourceFieldImpl
implements ResourceField {
    private final String jsonName;
    private final String underlyingName;
    private final Class<?> type;
    private final Type genericType;
    private final boolean lazy;
    private String oppositeResourceType;
    private LookupIncludeBehavior lookupIncludeBehavior;
    private boolean includeByDefault;
    private ResourceFieldType resourceFieldType;
    private String oppositeName;
    private ResourceInformation parentResourceInformation;
    private ResourceFieldAccessor accessor;
    private ResourceFieldAccess access;

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType) {
        this(jsonName, underlyingName, resourceFieldType, type, genericType, oppositeResourceType, null, true, false, LookupIncludeBehavior.NONE, new ResourceFieldAccess(true, true, true, true));
    }

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType, String oppositeName, boolean lazy, boolean includeByDefault, LookupIncludeBehavior lookupIncludeBehavior, ResourceFieldAccess access) {
        this.jsonName = jsonName;
        this.underlyingName = underlyingName;
        this.resourceFieldType = resourceFieldType;
        this.includeByDefault = includeByDefault;
        this.type = type;
        this.genericType = genericType;
        this.lazy = lazy;
        this.lookupIncludeBehavior = lookupIncludeBehavior;
        this.oppositeName = oppositeName;
        this.oppositeResourceType = oppositeResourceType;
        this.access = access;
    }

    @Override
    public ResourceFieldType getResourceFieldType() {
        return this.resourceFieldType;
    }

    @Override
    public LookupIncludeBehavior getLookupIncludeAutomatically() {
        return this.lookupIncludeBehavior;
    }

    @Override
    public String getOppositeName() {
        return this.oppositeName;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public String getOppositeResourceType() {
        PreconditionUtil.assertEquals("not an association", (Object)ResourceFieldType.RELATIONSHIP, (Object)this.resourceFieldType);
        PreconditionUtil.assertNotNull("resourceType must not be null", this.oppositeResourceType);
        return this.oppositeResourceType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean getIncludeByDefault() {
        return this.includeByDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldImpl that = (ResourceFieldImpl)o;
        return Objects.equals(this.jsonName, that.jsonName) && Objects.equals(this.underlyingName, that.underlyingName) && Objects.equals(this.type, that.type) && Objects.equals((Object)this.lookupIncludeBehavior, (Object)that.lookupIncludeBehavior) && Objects.equals(this.includeByDefault, that.includeByDefault) && Objects.equals(this.genericType, that.genericType) && Objects.equals(this.lazy, that.lazy) && Objects.equals(this.access, that.access);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonName, this.underlyingName, this.type, this.genericType, this.lazy, this.includeByDefault, this.lookupIncludeBehavior});
    }

    @Override
    public Class<?> getElementType() {
        if (Iterable.class.isAssignableFrom(this.type)) {
            return (Class)((ParameterizedType)this.getGenericType()).getActualTypeArguments()[0];
        }
        return this.type;
    }

    @Override
    public ResourceInformation getParentResourceInformation() {
        return this.parentResourceInformation;
    }

    @Override
    public ResourceFieldAccessor getAccessor() {
        if (this.accessor == null) {
            throw new IllegalStateException("field not properly initialized");
        }
        return this.accessor;
    }

    public void setAccessor(ResourceFieldAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void setResourceInformation(ResourceInformation resourceInformation) {
        if (this.accessor == null) {
            this.accessor = new ReflectionFieldAccessor(resourceInformation.getResourceClass(), this.underlyingName, this.type);
        }
        this.parentResourceInformation = resourceInformation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[jsonName=").append(this.jsonName);
        if (this.parentResourceInformation != null && this.parentResourceInformation.getResourceType() != null) {
            sb.append(",resourceType=").append(this.parentResourceInformation);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.getType());
    }

    @Override
    public ResourceFieldAccess getAccess() {
        return this.access;
    }
}

