/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

public class PreconditionUtil {
    private PreconditionUtil() {
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && PreconditionUtil.isEquals(expected, actual)) {
            return;
        }
        PreconditionUtil.failNotEquals(message, expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        PreconditionUtil.fail(PreconditionUtil.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + PreconditionUtil.formatClassAndValue(expected, expectedString) + " but was: " + PreconditionUtil.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    public static void fail(String message) {
        throw new IllegalStateException(message == null ? "" : message);
    }

    public static void assertNotNull(String message, Object object) {
        PreconditionUtil.assertTrue(message, object != null);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            PreconditionUtil.fail(message);
        }
    }

    public static void assertFalse(String message, boolean condition) {
        PreconditionUtil.assertTrue(message, !condition);
    }

    public static void assertNull(String message, Object object) {
        PreconditionUtil.assertTrue(message, object == null);
    }
}

