/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.parser;

import io.crnk.core.engine.internal.utils.MethodCache;
import io.crnk.core.engine.parser.DefaultStringParsers;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.StringParser;
import io.crnk.core.utils.Optional;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TypeParser {
    public final Map<Class, StringParser> parsers;
    private MethodCache methodCache = new MethodCache();

    public TypeParser() {
        this.parsers = new HashMap<Class, StringParser>();
        this.parsers.putAll(DefaultStringParsers.get());
    }

    private static <T extends Serializable> boolean isEnum(Class<T> clazz) {
        return clazz.isEnum();
    }

    public <T> void addParser(Class<T> clazz, StringParser<T> parser) {
        this.parsers.put(clazz, parser);
    }

    public <T extends Serializable> Iterable<T> parse(Iterable<String> inputs, Class<T> clazz) {
        LinkedList<T> parsedValues = new LinkedList<T>();
        for (String input : inputs) {
            parsedValues.add(this.parse(input, clazz));
        }
        return parsedValues;
    }

    public <T extends Serializable> T parse(String input, Class<T> clazz) {
        try {
            return this.parseInput(input, clazz);
        }
        catch (ParserException | IllegalAccessException | InstantiationException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            throw new ParserException(e.getMessage());
        }
    }

    private <T extends Serializable> T parseInput(String input, Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (String.class.equals(clazz)) {
            return (T)input;
        }
        if (this.parsers.containsKey(clazz)) {
            StringParser standardTypeParser = this.parsers.get(clazz);
            return (T)((Serializable)standardTypeParser.parse(input));
        }
        if (TypeParser.isEnum(clazz)) {
            return (T)Enum.valueOf(clazz.asSubclass(Enum.class), input.trim());
        }
        if (this.containsStringConstructor(clazz)) {
            return (T)((Serializable)clazz.getDeclaredConstructor(String.class).newInstance(input));
        }
        Optional<Method> method = this.methodCache.find(clazz, "parse", String.class);
        if (!method.isPresent()) {
            method = this.methodCache.find(clazz, "parse", CharSequence.class);
        }
        if (method.isPresent()) {
            try {
                return (T)((Serializable)method.get().invoke(clazz, input));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new ParserException(String.format("Cannot parse to %s : %s", clazz.getName(), input));
    }

    private boolean containsStringConstructor(Class<?> clazz) throws NoSuchMethodException {
        boolean result = false;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers()) || constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != String.class) continue;
            result = true;
        }
        return result;
    }
}

