/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.registry;

import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.DirectResponseRelationshipEntry;
import io.crnk.core.engine.internal.registry.DirectResponseResourceEntry;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class RegistryEntry {
    private final ResourceInformation resourceInformation;
    private final ResourceEntry resourceEntry;
    private final List<ResponseRelationshipEntry> relationshipEntries;
    @Deprecated
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;
    private ResourceRepositoryInformation repositoryInformation;

    public RegistryEntry(ResourceRepositoryInformation repositoryInformation, ResourceEntry resourceEntry) {
        this(repositoryInformation, resourceEntry, new LinkedList<ResponseRelationshipEntry>());
    }

    public RegistryEntry(ResourceRepositoryInformation repositoryInformation, ResourceEntry resourceEntry, List<ResponseRelationshipEntry> relationshipEntries) {
        this.repositoryInformation = repositoryInformation;
        this.resourceInformation = repositoryInformation.getResourceInformation();
        this.resourceEntry = resourceEntry;
        this.relationshipEntries = relationshipEntries;
    }

    public void initialize(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public ResourceRepositoryAdapter getResourceRepository(RepositoryMethodParameterProvider parameterProvider) {
        Object repoInstance = null;
        if (this.resourceEntry instanceof DirectResponseResourceEntry) {
            repoInstance = ((DirectResponseResourceEntry)this.resourceEntry).getResourceRepository();
        } else if (this.resourceEntry instanceof AnnotatedResourceEntry) {
            repoInstance = ((AnnotatedResourceEntry)this.resourceEntry).build(parameterProvider);
        }
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return new ResourceRepositoryAdapter(this.resourceInformation, this.moduleRegistry, repoInstance);
    }

    public List<ResponseRelationshipEntry> getRelationshipEntries() {
        return this.relationshipEntries;
    }

    public RelationshipRepositoryAdapter getRelationshipRepositoryForClass(Class<?> clazz, RepositoryMethodParameterProvider parameterProvider) {
        ResponseRelationshipEntry foundRelationshipEntry = null;
        for (ResponseRelationshipEntry relationshipEntry : this.relationshipEntries) {
            if (clazz != relationshipEntry.getTargetAffiliation()) continue;
            foundRelationshipEntry = relationshipEntry;
            break;
        }
        if (foundRelationshipEntry == null) {
            throw new RelationshipRepositoryNotFoundException(this.resourceInformation.getResourceClass(), clazz);
        }
        Object repoInstance = foundRelationshipEntry instanceof AnnotatedRelationshipEntryBuilder ? ((AnnotatedRelationshipEntryBuilder)foundRelationshipEntry).build(parameterProvider) : ((DirectResponseRelationshipEntry)foundRelationshipEntry).getRepositoryInstanceBuilder();
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return new RelationshipRepositoryAdapter(this.resourceInformation, this.moduleRegistry, repoInstance);
    }

    public ResourceInformation getResourceInformation() {
        return this.resourceInformation;
    }

    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public RegistryEntry getParentRegistryEntry() {
        String superResourceType = this.resourceInformation.getSuperResourceType();
        if (superResourceType != null) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry parentRegistryEntry = this.getParentRegistryEntry(); parentRegistryEntry != null; parentRegistryEntry = parentRegistryEntry.getParentRegistryEntry()) {
            if (!parentRegistryEntry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RegistryEntry)) {
            return false;
        }
        RegistryEntry that = (RegistryEntry)o;
        return Objects.equals(this.resourceInformation, that.resourceInformation) && Objects.equals(this.repositoryInformation, that.repositoryInformation) && Objects.equals(this.resourceEntry, that.resourceEntry) && Objects.equals(this.moduleRegistry, that.moduleRegistry) && Objects.equals(this.relationshipEntries, that.relationshipEntries) && Objects.equals(this.parentRegistryEntry, that.parentRegistryEntry);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryInformation, this.resourceInformation, this.resourceEntry, this.relationshipEntries, this.moduleRegistry, this.parentRegistryEntry);
    }
}

