/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module.discovery;

import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.repository.BulkRelationshipRepositoryV2;
import io.crnk.core.repository.RelationshipRepositoryBase;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.legacy.repository.RelationshipRepository;
import io.crnk.legacy.repository.ResourceRepository;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class DefaultResourceLookup
implements ResourceLookup {
    private Reflections reflections;

    public DefaultResourceLookup(String packageName) {
        if (packageName != null) {
            String[] packageNamesArray = packageName.split(",");
            this.reflections = new Reflections((Object[])packageNamesArray);
        } else {
            this.reflections = new Reflections(packageName, new Scanner[0]);
        }
    }

    @Override
    public Set<Class<?>> getResourceClasses() {
        return this.reflections.getTypesAnnotatedWith(JsonApiResource.class);
    }

    @Override
    public Set<Class<?>> getResourceRepositoryClasses() {
        Set annotatedResourceRepositories = this.reflections.getTypesAnnotatedWith(JsonApiResourceRepository.class);
        Set annotatedRelationshipRepositories = this.reflections.getTypesAnnotatedWith(JsonApiRelationshipRepository.class);
        Set resourceRepositories = this.reflections.getSubTypesOf(ResourceRepository.class);
        Set relationshipRepositories = this.reflections.getSubTypesOf(RelationshipRepository.class);
        Set querySpecResourceRepositories = this.reflections.getSubTypesOf(ResourceRepositoryV2.class);
        Set querySpecRelationshipRepositories = this.reflections.getSubTypesOf(RelationshipRepositoryV2.class);
        HashSet result = new HashSet();
        result.addAll(annotatedResourceRepositories);
        result.addAll(annotatedRelationshipRepositories);
        result.addAll(resourceRepositories);
        result.addAll(relationshipRepositories);
        result.addAll(querySpecResourceRepositories);
        result.addAll(querySpecRelationshipRepositories);
        result.addAll(this.reflections.getSubTypesOf(BulkRelationshipRepositoryV2.class));
        result.addAll(this.reflections.getSubTypesOf(ResourceRepositoryBase.class));
        result.addAll(this.reflections.getSubTypesOf(RelationshipRepositoryBase.class));
        result.addAll(this.reflections.getSubTypesOf(RelationshipRepositoryBase.class));
        result.addAll(this.reflections.getSubTypesOf(ResourceRepositoryBase.class));
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Class repoClass = (Class)iterator.next();
            if (!repoClass.isInterface() && !Modifier.isAbstract(repoClass.getModifiers())) continue;
            iterator.remove();
        }
        return result;
    }
}

