/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.internal;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.RepositoryAnnotationNotFoundException;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.legacy.internal.ParametersFactory;
import io.crnk.legacy.repository.annotations.JsonApiLinks;
import io.crnk.legacy.repository.annotations.JsonApiMeta;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AnnotatedRepositoryAdapter<T> {
    final Object implementationObject;
    final Class<?> implementationClass;
    final ParametersFactory parametersFactory;
    private Method linksMethod;
    private Method metaMethod;

    public AnnotatedRepositoryAdapter(Object implementationObject, ParametersFactory parametersFactory) {
        this.implementationObject = implementationObject;
        this.implementationClass = implementationObject.getClass();
        this.parametersFactory = parametersFactory;
    }

    public boolean linksRepositoryAvailable() {
        this.assignLinksMethod();
        return this.linksMethod != null;
    }

    public LinksInformation getLinksInformation(Iterable<T> resources, QueryAdapter queryAdapter) {
        Class<JsonApiLinks> annotationType = JsonApiLinks.class;
        this.assignLinksMethod();
        this.checkIfNotNull(annotationType, this.linksMethod);
        Object[] methodParameters = this.parametersFactory.buildParameters(new Object[]{resources}, this.linksMethod, queryAdapter, annotationType);
        return (LinksInformation)this.invoke(this.linksMethod, methodParameters);
    }

    private void assignLinksMethod() {
        if (this.linksMethod == null) {
            this.linksMethod = ClassUtils.findMethodWith(this.implementationClass, JsonApiLinks.class);
        }
    }

    public boolean metaRepositoryAvailable() {
        this.assignMetaMethod();
        return this.metaMethod != null;
    }

    public MetaInformation getMetaInformation(Iterable<T> resources, QueryAdapter queryAdapter) {
        Class<JsonApiMeta> annotationType = JsonApiMeta.class;
        this.assignMetaMethod();
        this.checkIfNotNull(annotationType, this.metaMethod);
        Object[] methodParameters = this.parametersFactory.buildParameters(new Object[]{resources}, this.metaMethod, queryAdapter, annotationType);
        return (MetaInformation)this.invoke(this.metaMethod, methodParameters);
    }

    private void assignMetaMethod() {
        if (this.metaMethod == null) {
            this.metaMethod = ClassUtils.findMethodWith(this.implementationClass, JsonApiMeta.class);
        }
    }

    protected void checkIfNotNull(Class<? extends Annotation> annotationClass, Method foundMethod) {
        if (foundMethod == null) {
            throw new RepositoryAnnotationNotFoundException(String.format("Annotation %s for class %s not found", annotationClass, this.implementationObject.getClass()));
        }
    }

    protected <TYPE> TYPE invokeOperation(Method foundMethod, Class<? extends Annotation> annotationType, Object[] firstParameters) {
        this.checkIfNotNull(annotationType, foundMethod);
        Object[] methodParameters = this.parametersFactory.buildParameters(firstParameters, foundMethod, annotationType);
        return this.invoke(foundMethod, methodParameters);
    }

    protected <TYPE> TYPE invokeOperation(Method foundMethod, Class<? extends Annotation> annotationType, Object[] firstParameters, QueryAdapter queryAdapter) {
        this.checkIfNotNull(annotationType, foundMethod);
        Object[] methodParameters = this.parametersFactory.buildParameters(firstParameters, foundMethod, queryAdapter, annotationType);
        return this.invoke(foundMethod, methodParameters);
    }

    private <TYPE> TYPE invoke(Method method, Object ... args) {
        try {
            return (TYPE)method.invoke(this.implementationObject, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public Object getImplementationObject() {
        return this.implementationObject;
    }
}

