/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.internal;

import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.RepositoryMethodException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.queryParams.QueryParams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ParametersFactory {
    private final RepositoryMethodParameterProvider parameterProvider;
    private ModuleRegistry moduleRegistry;

    public ParametersFactory(ModuleRegistry moduleRegistry, RepositoryMethodParameterProvider parameterProvider) {
        this.parameterProvider = parameterProvider;
        this.moduleRegistry = moduleRegistry;
    }

    private static Object[] concatenate(Object[] a, Object[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] newArray = new Object[aLen + bLen];
        System.arraycopy(a, 0, newArray, 0, aLen);
        System.arraycopy(b, 0, newArray, aLen, bLen);
        return newArray;
    }

    public Object[] buildParameters(Object[] firstParameters, Method method, QueryAdapter queryAdapter, Class<? extends Annotation> annotationType) {
        int parametersLength = method.getParameterTypes().length;
        if (firstParameters.length > 0 && parametersLength < 1) {
            throw new RepositoryMethodException(String.format("Method with %s annotation should have at least one parameter.", annotationType));
        }
        int parametersToResolve = parametersLength - firstParameters.length;
        Object[] additionalParameters = new Object[parametersToResolve];
        for (int i = firstParameters.length; i < parametersLength; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            additionalParameters[i - firstParameters.length] = this.isQueryType(parameterType) ? this.toQueryObject(queryAdapter, parameterType) : this.parameterProvider.provide(method, i);
        }
        return ParametersFactory.concatenate(firstParameters, additionalParameters);
    }

    public boolean isQueryType(Class<?> parameterType) {
        return QueryParams.class.equals(parameterType) || QuerySpec.class.equals(parameterType);
    }

    public Object toQueryObject(QueryAdapter queryAdapter, Class<?> parameterType) {
        if (queryAdapter == null || !this.isQueryType(parameterType)) {
            return null;
        }
        if (QueryParams.class.equals(parameterType)) {
            return queryAdapter.toQueryParams();
        }
        return queryAdapter.toQuerySpec();
    }

    public Object[] buildParameters(Object[] firstParameters, Method method, Class<? extends Annotation> annotationType) {
        int parametersLength = method.getParameterTypes().length;
        if (firstParameters.length > 0 && parametersLength < 1) {
            throw new RepositoryMethodException(String.format("Method with %s annotation should have at least one parameter.", annotationType));
        }
        int parametersToResolve = parametersLength - firstParameters.length;
        Object[] additionalParameters = new Object[parametersToResolve];
        for (int i = firstParameters.length; i < parametersLength; ++i) {
            additionalParameters[i - firstParameters.length] = this.parameterProvider.provide(method, i);
        }
        return ParametersFactory.concatenate(firstParameters, additionalParameters);
    }
}

