/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.queryParams;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.legacy.queryParams.QueryParams;
import io.crnk.legacy.queryParams.QueryParamsConverter;
import io.crnk.legacy.queryParams.RestrictedPaginationKeys;
import io.crnk.legacy.queryParams.RestrictedSortingValues;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.FilterParams;
import io.crnk.legacy.queryParams.params.GroupingParams;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.SortingParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DefaultQueryParamsConverter
implements QueryParamsConverter {
    private ResourceRegistry resourceRegistry;

    public DefaultQueryParamsConverter(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public QueryParams fromParams(Class<?> rootType, QuerySpec querySpec) {
        QueryParams params = new QueryParams();
        this.applyIncludedFields(querySpec, params);
        this.applySorting(querySpec, params);
        this.applyRelatedFields(querySpec, params);
        this.applyPaging(querySpec, params);
        this.applyFiltering(querySpec, params);
        params.setGrouping(new TypedParams<GroupingParams>(Collections.unmodifiableMap(new HashMap())));
        return params;
    }

    private String getResourceType(Class<?> resourceClass) {
        RegistryEntry registryEntry = this.resourceRegistry.getEntryForClass(resourceClass);
        if (registryEntry == null) {
            throw new IllegalArgumentException("resourceType for class " + resourceClass.getName() + " not found");
        }
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        return resourceInformation.getResourceType();
    }

    protected void applyFiltering(QuerySpec spec, QueryParams queryParams) {
        List<FilterSpec> filters = spec.getFilters();
        LinkedHashMap<String, FilterParams> decodedFiltersMap = new LinkedHashMap<String, FilterParams>();
        if (filters != null && !filters.isEmpty()) {
            String resourceType = this.getResourceType(spec.getResourceClass());
            LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
            for (FilterSpec filter : filters) {
                String key = this.joinPath(filter.getAttributePath());
                if (filter.getOperator() != null && filter.getOperator() != FilterOperator.EQ) {
                    key = key + "." + filter.getOperator().name();
                }
                LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
                if (filter.getValue() instanceof Set) {
                    for (Object value : (Set)filter.getValue()) {
                        valueSet.add(value.toString());
                    }
                } else {
                    valueSet.add(filter.getValue().toString());
                }
                map.put(key, valueSet);
            }
            decodedFiltersMap.put(resourceType, new FilterParams(map));
        }
        queryParams.setFilters(new TypedParams<FilterParams>(Collections.unmodifiableMap(decodedFiltersMap)));
    }

    private String joinPath(List<String> pathList) {
        return StringUtils.join(".", pathList);
    }

    protected void applyIncludedFields(QuerySpec spec, QueryParams queryParams) {
        List<IncludeFieldSpec> includedFields = spec.getIncludedFields();
        LinkedHashMap<String, IncludedFieldsParams> decodedSparseMap = new LinkedHashMap<String, IncludedFieldsParams>();
        if (includedFields != null && !includedFields.isEmpty()) {
            String resourceType = this.getResourceType(spec.getResourceClass());
            LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
            for (IncludeFieldSpec includedField : includedFields) {
                String path = this.joinPath(includedField.getAttributePath());
                pathSet.add(path);
            }
            IncludedFieldsParams includedFieldsParams = new IncludedFieldsParams(pathSet);
            decodedSparseMap.put(resourceType, includedFieldsParams);
        }
        queryParams.setIncludedFields(new TypedParams<IncludedFieldsParams>(Collections.unmodifiableMap(decodedSparseMap)));
    }

    protected void applyRelatedFields(QuerySpec spec, QueryParams queryParams) {
        List<IncludeRelationSpec> includedRelations = spec.getIncludedRelations();
        LinkedHashMap<String, IncludedRelationsParams> decodedSparseMap = new LinkedHashMap<String, IncludedRelationsParams>();
        if (includedRelations != null && !includedRelations.isEmpty()) {
            String resourceType = this.getResourceType(spec.getResourceClass());
            LinkedHashSet<Inclusion> inclusions = new LinkedHashSet<Inclusion>();
            for (IncludeRelationSpec relationSpec : includedRelations) {
                for (String attrPath : relationSpec.getAttributePath()) {
                    Inclusion inclusion = new Inclusion(attrPath);
                    inclusions.add(inclusion);
                }
            }
            IncludedRelationsParams includedRelationsParams = new IncludedRelationsParams(Collections.unmodifiableSet(inclusions));
            decodedSparseMap.put(resourceType, includedRelationsParams);
        }
        queryParams.setIncludedRelations(new TypedParams<IncludedRelationsParams>(Collections.unmodifiableMap(decodedSparseMap)));
    }

    protected void applySorting(QuerySpec spec, QueryParams queryParams) {
        List<SortSpec> sortSpecs = spec.getSort();
        LinkedHashMap<String, SortingParams> decodedSortingMap = new LinkedHashMap<String, SortingParams>();
        if (sortSpecs != null && !sortSpecs.isEmpty()) {
            String resourceType = this.getResourceType(spec.getResourceClass());
            for (SortSpec sortSpec : sortSpecs) {
                HashMap<String, RestrictedSortingValues> sortingValues = new HashMap<String, RestrictedSortingValues>();
                String joinedPath = this.joinPath(sortSpec.getAttributePath());
                RestrictedSortingValues sortValue = sortSpec.getDirection() == Direction.DESC ? RestrictedSortingValues.desc : RestrictedSortingValues.asc;
                SortingParams sortingParams = new SortingParams(sortingValues);
                sortingValues.put(joinedPath, sortValue);
                decodedSortingMap.put(resourceType, sortingParams);
            }
        }
        queryParams.setSorting(new TypedParams<SortingParams>(Collections.unmodifiableMap(decodedSortingMap)));
    }

    protected void applyPaging(QuerySpec spec, QueryParams queryParams) {
        Long limit = spec.getLimit();
        long offset = spec.getOffset();
        LinkedHashMap<RestrictedPaginationKeys, Integer> decodedPagination = new LinkedHashMap<RestrictedPaginationKeys, Integer>();
        decodedPagination.put(RestrictedPaginationKeys.offset, new BigDecimal(offset).intValueExact());
        if (limit != null) {
            decodedPagination.put(RestrictedPaginationKeys.limit, new BigDecimal(limit).intValueExact());
        }
        queryParams.setPagination(Collections.unmodifiableMap(decodedPagination));
    }
}

