/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.queryParams;

import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.resource.RestrictedQueryParamsMembers;
import io.crnk.legacy.queryParams.QueryParams;
import io.crnk.legacy.queryParams.QueryParamsParser;
import io.crnk.legacy.queryParams.RestrictedPaginationKeys;
import io.crnk.legacy.queryParams.RestrictedSortingValues;
import io.crnk.legacy.queryParams.context.QueryParamsParserContext;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.FilterParams;
import io.crnk.legacy.queryParams.params.GroupingParams;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.SortingParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class DefaultQueryParamsParser
implements QueryParamsParser {
    protected static List<String> buildPropertyListFromEntry(Map.Entry<String, Set<String>> entry, String prefix) {
        String entryKey = entry.getKey().substring(prefix.length());
        String pattern = "[^\\]\\[]+(?<!\\[)(?=\\])";
        Pattern regexp = Pattern.compile(pattern);
        Matcher matcher = regexp.matcher(entryKey);
        LinkedList<String> matchList = new LinkedList<String>();
        while (matcher.find()) {
            matchList.add(matcher.group());
        }
        if (matchList.isEmpty()) {
            throw new ParametersDeserializationException("Malformed filter parameter: " + entryKey);
        }
        return matchList;
    }

    protected TypedParams<FilterParams> parseFiltersParameters(QueryParamsParserContext context) {
        String filterKey = RestrictedQueryParamsMembers.filter.name();
        Map<String, Set<String>> filters = this.filterQueryParamsByKey(context, filterKey);
        LinkedHashMap temporaryFiltersMap = new LinkedHashMap();
        for (Map.Entry<String, Set<String>> entry : filters.entrySet()) {
            Map<String, Set<String>> resourceParams;
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, filterKey);
            String resourceType = propertyList.get(0);
            String propertyPath = StringUtils.join(".", propertyList.subList(1, propertyList.size()));
            if (temporaryFiltersMap.containsKey(resourceType)) {
                resourceParams = (Map)temporaryFiltersMap.get(resourceType);
                resourceParams.put(propertyPath, Collections.unmodifiableSet(entry.getValue()));
                continue;
            }
            resourceParams = new LinkedHashMap();
            temporaryFiltersMap.put(resourceType, resourceParams);
            resourceParams.put(propertyPath, entry.getValue());
        }
        LinkedHashMap decodedFiltersMap = new LinkedHashMap();
        for (Map.Entry resourceTypesMap : temporaryFiltersMap.entrySet()) {
            Map<String, Set<String>> filtersMap = Collections.unmodifiableMap((Map)resourceTypesMap.getValue());
            decodedFiltersMap.put(resourceTypesMap.getKey(), new FilterParams(filtersMap));
        }
        return new TypedParams<FilterParams>(Collections.unmodifiableMap(decodedFiltersMap));
    }

    protected TypedParams<SortingParams> parseSortingParameters(QueryParamsParserContext context) {
        String sortingKey = RestrictedQueryParamsMembers.sort.name();
        Map<String, Set<String>> sorting = this.filterQueryParamsByKey(context, sortingKey);
        LinkedHashMap temporarySortingMap = new LinkedHashMap();
        for (Map.Entry<String, Set<String>> entry : sorting.entrySet()) {
            Map<String, RestrictedSortingValues> resourceParams;
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, sortingKey);
            String resourceType = propertyList.get(0);
            String propertyPath = StringUtils.join(".", propertyList.subList(1, propertyList.size()));
            if (temporarySortingMap.containsKey(resourceType)) {
                resourceParams = (Map)temporarySortingMap.get(resourceType);
                resourceParams.put(propertyPath, RestrictedSortingValues.valueOf(entry.getValue().iterator().next()));
                continue;
            }
            resourceParams = new HashMap();
            temporarySortingMap.put(resourceType, resourceParams);
            resourceParams.put(propertyPath, RestrictedSortingValues.valueOf(entry.getValue().iterator().next()));
        }
        LinkedHashMap decodedSortingMap = new LinkedHashMap();
        for (Map.Entry resourceTypesMap : temporarySortingMap.entrySet()) {
            Map<String, RestrictedSortingValues> sortingMap = Collections.unmodifiableMap((Map)resourceTypesMap.getValue());
            decodedSortingMap.put(resourceTypesMap.getKey(), new SortingParams(sortingMap));
        }
        return new TypedParams<SortingParams>(Collections.unmodifiableMap(decodedSortingMap));
    }

    protected TypedParams<GroupingParams> parseGroupingParameters(QueryParamsParserContext context) {
        String groupingKey = RestrictedQueryParamsMembers.group.name();
        Map<String, Set<String>> grouping = this.filterQueryParamsByKey(context, groupingKey);
        LinkedHashMap temporaryGroupingMap = new LinkedHashMap();
        for (Map.Entry<String, Set<String>> entry : grouping.entrySet()) {
            Set resourceParams;
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, groupingKey);
            if (propertyList.size() > 1) {
                throw new ParametersDeserializationException("Exceeded maximum level of nesting of 'group' parameter (1) eg. group[tasks][name] <-- #2 level and more are not allowed");
            }
            String resourceType = propertyList.get(0);
            if (temporaryGroupingMap.containsKey(resourceType)) {
                resourceParams = (Set)temporaryGroupingMap.get(resourceType);
                resourceParams.addAll(entry.getValue());
                temporaryGroupingMap.put(resourceType, resourceParams);
                continue;
            }
            resourceParams = new LinkedHashSet();
            resourceParams.addAll(entry.getValue());
            temporaryGroupingMap.put(resourceType, resourceParams);
        }
        LinkedHashMap decodedGroupingMap = new LinkedHashMap();
        for (Map.Entry resourceTypesMap : temporaryGroupingMap.entrySet()) {
            Set<String> groupingSet = Collections.unmodifiableSet((Set)resourceTypesMap.getValue());
            decodedGroupingMap.put(resourceTypesMap.getKey(), new GroupingParams(groupingSet));
        }
        return new TypedParams<GroupingParams>(Collections.unmodifiableMap(decodedGroupingMap));
    }

    protected TypedParams<IncludedFieldsParams> parseIncludedFieldsParameters(QueryParamsParserContext context) {
        String sparseKey = RestrictedQueryParamsMembers.fields.name();
        Map<String, Set<String>> sparse = this.filterQueryParamsByKey(context, sparseKey);
        LinkedHashMap temporarySparseMap = new LinkedHashMap();
        for (Map.Entry<String, Set<String>> entry : sparse.entrySet()) {
            Set resourceParams;
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, sparseKey);
            if (propertyList.size() > 1) {
                throw new ParametersDeserializationException("Exceeded maximum level of nesting of 'fields' parameter (1) eg. fields[tasks][name] <-- #2 level and more are not allowed");
            }
            String resourceType = propertyList.get(0);
            if (temporarySparseMap.containsKey(resourceType)) {
                resourceParams = (Set)temporarySparseMap.get(resourceType);
                resourceParams.addAll(entry.getValue());
                temporarySparseMap.put(resourceType, resourceParams);
                continue;
            }
            resourceParams = new LinkedHashSet();
            resourceParams.addAll(entry.getValue());
            temporarySparseMap.put(resourceType, resourceParams);
        }
        LinkedHashMap decodedSparseMap = new LinkedHashMap();
        for (Map.Entry resourceTypesMap : temporarySparseMap.entrySet()) {
            Set<String> sparseSet = Collections.unmodifiableSet((Set)resourceTypesMap.getValue());
            decodedSparseMap.put(resourceTypesMap.getKey(), new IncludedFieldsParams(sparseSet));
        }
        return new TypedParams<IncludedFieldsParams>(Collections.unmodifiableMap(decodedSparseMap));
    }

    protected TypedParams<IncludedRelationsParams> parseIncludedRelationsParameters(QueryParamsParserContext context) {
        String includeKey = RestrictedQueryParamsMembers.include.name();
        Map<String, Set<String>> inclusions = this.filterQueryParamsByKey(context, includeKey);
        LinkedHashMap temporaryInclusionsMap = new LinkedHashMap();
        for (Map.Entry<String, Set<String>> entry : inclusions.entrySet()) {
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, includeKey);
            if (propertyList.size() > 1) {
                throw new ParametersDeserializationException("Exceeded maximum level of nesting of 'include' parameter (1)");
            }
            String resourceType = propertyList.get(0);
            Set resourceParams = temporaryInclusionsMap.containsKey(resourceType) ? (Set)temporaryInclusionsMap.get(resourceType) : new LinkedHashSet();
            for (String path : entry.getValue()) {
                resourceParams.add(new Inclusion(path));
            }
            temporaryInclusionsMap.put(resourceType, resourceParams);
        }
        LinkedHashMap decodedInclusions = new LinkedHashMap();
        for (Map.Entry resourceTypesMap : temporaryInclusionsMap.entrySet()) {
            Set<Inclusion> inclusionSet = Collections.unmodifiableSet((Set)resourceTypesMap.getValue());
            decodedInclusions.put(resourceTypesMap.getKey(), new IncludedRelationsParams(inclusionSet));
        }
        return new TypedParams<IncludedRelationsParams>(Collections.unmodifiableMap(decodedInclusions));
    }

    protected Map<RestrictedPaginationKeys, Integer> parsePaginationParameters(QueryParamsParserContext context) {
        String pagingKey = RestrictedQueryParamsMembers.page.name();
        Map<String, Set<String>> pagination = this.filterQueryParamsByKey(context, pagingKey);
        LinkedHashMap<RestrictedPaginationKeys, Integer> decodedPagination = new LinkedHashMap<RestrictedPaginationKeys, Integer>();
        for (Map.Entry<String, Set<String>> entry : pagination.entrySet()) {
            List<String> propertyList = DefaultQueryParamsParser.buildPropertyListFromEntry(entry, RestrictedQueryParamsMembers.page.name());
            if (propertyList.size() > 1) {
                throw new ParametersDeserializationException("Exceeded maximum level of nesting of 'page' parameter (1) eg. page[offset][minimal] <-- #2 level and more are not allowed");
            }
            String resourceType = propertyList.get(0);
            decodedPagination.put(RestrictedPaginationKeys.valueOf(resourceType), Integer.parseInt(entry.getValue().iterator().next()));
        }
        return Collections.unmodifiableMap(decodedPagination);
    }

    protected Map<String, Set<String>> filterQueryParamsByKey(QueryParamsParserContext context, String queryKey) {
        HashMap<String, Set<String>> filteredQueryParams = new HashMap<String, Set<String>>();
        for (String paramName : context.getParameterNames()) {
            if (!paramName.startsWith(queryKey)) continue;
            filteredQueryParams.put(paramName, context.getParameterValue(paramName));
        }
        return filteredQueryParams;
    }

    @Override
    public QueryParams parse(QueryParamsParserContext context) {
        QueryParams queryParams = new QueryParams();
        queryParams.setFilters(this.parseFiltersParameters(context));
        queryParams.setSorting(this.parseSortingParameters(context));
        queryParams.setGrouping(this.parseGroupingParameters(context));
        queryParams.setPagination(this.parsePaginationParameters(context));
        queryParams.setIncludedFields(this.parseIncludedFieldsParameters(context));
        queryParams.setIncludedRelations(this.parseIncludedRelationsParameters(context));
        return queryParams;
    }
}

