/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.registry;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Optional;
import io.crnk.legacy.internal.AnnotatedRelationshipRepositoryAdapter;
import io.crnk.legacy.internal.ParametersFactory;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;

public class AnnotatedRelationshipEntryBuilder
implements ResponseRelationshipEntry {
    private RepositoryInstanceBuilder repositoryInstanceBuilder;
    private ModuleRegistry moduleRegistry;

    public AnnotatedRelationshipEntryBuilder(ModuleRegistry moduleRegistry, RepositoryInstanceBuilder repositoryInstanceBuilder) {
        this.moduleRegistry = moduleRegistry;
        this.repositoryInstanceBuilder = repositoryInstanceBuilder;
    }

    @Override
    public Class<?> getTargetAffiliation() {
        Optional<JsonApiRelationshipRepository> annotation = ClassUtils.getAnnotation(this.repositoryInstanceBuilder.getRepositoryClass(), JsonApiRelationshipRepository.class);
        if (annotation.isPresent()) {
            return annotation.get().target();
        }
        throw new IllegalArgumentException(String.format("Class %s must be annotated with @JsonApiRelationshipRepository", this.repositoryInstanceBuilder.getClass().getName()));
    }

    public AnnotatedRelationshipRepositoryAdapter build(RepositoryMethodParameterProvider parameterProvider) {
        return new AnnotatedRelationshipRepositoryAdapter(this.repositoryInstanceBuilder.buildRepository(), new ParametersFactory(this.moduleRegistry, parameterProvider));
    }

    public String toString() {
        return "AnnotatedRelationshipEntryBuilder{repositoryInstanceBuilder=" + this.repositoryInstanceBuilder + '}';
    }
}

