/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceFieldNameTransformer;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistryBuilder;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.HttpRequestProcessorImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessor;
import io.crnk.core.engine.internal.information.resource.AnnotationResourceInformationBuilder;
import io.crnk.core.engine.internal.jackson.JsonApiModuleBuilder;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.DefaultServiceDiscoveryFactory;
import io.crnk.core.module.discovery.FallbackServiceDiscoveryFactory;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.discovery.ServiceDiscoveryFactory;
import io.crnk.core.queryspec.DefaultQuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.internal.QuerySpecAdapterBuilder;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.Repository;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.legacy.internal.QueryParamsAdapterBuilder;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.locator.SampleJsonServiceLocator;
import io.crnk.legacy.queryParams.QueryParamsBuilder;
import io.crnk.legacy.repository.RelationshipRepository;
import io.crnk.legacy.repository.ResourceRepository;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import io.crnk.legacy.repository.information.DefaultRelationshipRepositoryInformationBuilder;
import io.crnk.legacy.repository.information.DefaultResourceRepositoryInformationBuilder;
import java.lang.annotation.Annotation;
import java.util.List;
import net.jodah.typetools.TypeResolver;

public class CrnkBoot {
    private final ModuleRegistry moduleRegistry = new ModuleRegistry();
    private ObjectMapper objectMapper;
    private QueryParamsBuilder queryParamsBuilder;
    private QuerySpecDeserializer querySpecDeserializer = new DefaultQuerySpecDeserializer();
    private ServiceUrlProvider serviceUrlProvider;
    private boolean configured;
    private JsonServiceLocator serviceLocator = new SampleJsonServiceLocator();
    private ResourceRegistry resourceRegistry;
    private HttpRequestProcessorImpl requestDispatcher;
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ResourceFieldNameTransformer resourceFieldNameTransformer;
    private ServiceUrlProvider defaultServiceUrlProvider = new HttpRequestContextProvider();
    private ServiceDiscoveryFactory serviceDiscoveryFactory = new DefaultServiceDiscoveryFactory();
    private ServiceDiscovery serviceDiscovery;
    private DocumentMapper documentMapper;

    private static String buildServiceUrl(String resourceDefaultDomain, String webPathPrefix) {
        return resourceDefaultDomain + (webPathPrefix != null ? webPathPrefix : "");
    }

    public void setServiceDiscoveryFactory(ServiceDiscoveryFactory factory) {
        this.checkNotConfiguredYet();
        this.serviceDiscoveryFactory = factory;
    }

    public void setQueryParamsBuilds(QueryParamsBuilder queryParamsBuilder) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query params builder must be provided, but is null", queryParamsBuilder);
        this.queryParamsBuilder = queryParamsBuilder;
        this.querySpecDeserializer = null;
    }

    public void setServiceLocator(JsonServiceLocator serviceLocator) {
        this.checkNotConfiguredYet();
        this.serviceLocator = serviceLocator;
    }

    public void addModule(Module module) {
        this.checkNotConfiguredYet();
        this.moduleRegistry.addModule(module);
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.checkNotConfiguredYet();
        this.serviceUrlProvider = serviceUrlProvider;
    }

    private void checkNotConfiguredYet() {
        if (this.configured) {
            throw new IllegalStateException("cannot further modify CrnkFeature once configured/initialized by JAX-RS");
        }
    }

    public void boot() {
        this.checkNotConfiguredYet();
        this.configured = true;
        this.setupServiceUrlProvider();
        this.setupServiceDiscovery();
        this.bootDiscovery();
    }

    private void setupServiceDiscovery() {
        if (this.serviceDiscovery == null) {
            FallbackServiceDiscoveryFactory fallback = new FallbackServiceDiscoveryFactory(this.serviceDiscoveryFactory, this.serviceLocator, this.propertiesProvider);
            this.setServiceDiscovery(fallback.getInstance());
        }
    }

    private void bootDiscovery() {
        this.setupObjectMapper();
        this.addModules();
        this.setupComponents();
        this.resourceRegistry = new ResourceRegistryImpl(this.moduleRegistry, this.serviceUrlProvider);
        this.moduleRegistry.init(this.objectMapper);
        JsonApiModuleBuilder jsonApiModuleBuilder = new JsonApiModuleBuilder();
        this.objectMapper.registerModule((com.fasterxml.jackson.databind.Module)jsonApiModuleBuilder.build());
        this.requestDispatcher = this.createRequestDispatcher(this.moduleRegistry.getExceptionMapperRegistry());
    }

    private void setupObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.findAndRegisterModules();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.moduleRegistry.getExceptionMapperRegistry();
    }

    private HttpRequestProcessorImpl createRequestDispatcher(ExceptionMapperRegistry exceptionMapperRegistry) {
        ControllerRegistryBuilder controllerRegistryBuilder = new ControllerRegistryBuilder(this.resourceRegistry, this.moduleRegistry.getTypeParser(), this.objectMapper, this.propertiesProvider);
        ControllerRegistry controllerRegistry = controllerRegistryBuilder.build();
        this.documentMapper = controllerRegistryBuilder.getDocumentMapper();
        QueryAdapterBuilder queryAdapterBuilder = this.queryParamsBuilder != null ? new QueryParamsAdapterBuilder(this.queryParamsBuilder, this.moduleRegistry) : new QuerySpecAdapterBuilder(this.querySpecDeserializer, this.moduleRegistry);
        return new HttpRequestProcessorImpl(this.moduleRegistry, controllerRegistry, exceptionMapperRegistry, queryAdapterBuilder);
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    private void setupComponents() {
        Annotation annotation;
        if (this.resourceFieldNameTransformer == null) {
            this.resourceFieldNameTransformer = new ResourceFieldNameTransformer(this.objectMapper.getSerializationConfig());
        }
        SimpleModule module = new SimpleModule("discovery"){

            @Override
            public void setupModule(Module.ModuleContext context) {
                this.addHttpRequestProcessor(new JsonApiRequestProcessor(context));
                super.setupModule(context);
            }
        };
        module.addRepositoryInformationBuilder(new DefaultResourceRepositoryInformationBuilder());
        module.addRepositoryInformationBuilder(new DefaultRelationshipRepositoryInformationBuilder());
        module.addResourceInformationBuilder(new AnnotationResourceInformationBuilder(this.resourceFieldNameTransformer));
        for (JsonApiExceptionMapper jsonApiExceptionMapper : this.serviceDiscovery.getInstancesByType(JsonApiExceptionMapper.class)) {
            module.addExceptionMapper(jsonApiExceptionMapper);
        }
        for (DocumentFilter documentFilter : this.serviceDiscovery.getInstancesByType(DocumentFilter.class)) {
            module.addFilter(documentFilter);
        }
        for (Object object : this.serviceDiscovery.getInstancesByType(Repository.class)) {
            this.setupRepository(module, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiResourceRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiResourceRepository.class).get();
            Class<?> resourceClass = annotation.value();
            module.addRepository(resourceClass, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiRelationshipRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiRelationshipRepository.class).get();
            module.addRepository(annotation.source(), annotation.target(), object);
        }
        this.moduleRegistry.addModule(module);
    }

    private void setupRepository(SimpleModule module, Object repository) {
        if (repository instanceof ResourceRepository) {
            ResourceRepository resRepository = (ResourceRepository)repository;
            Class[] typeArgs = TypeResolver.resolveRawArguments(ResourceRepository.class, resRepository.getClass());
            Class resourceClass = typeArgs[0];
            module.addRepository(resourceClass, resRepository);
        } else if (repository instanceof RelationshipRepository) {
            RelationshipRepository relRepository = (RelationshipRepository)repository;
            Class[] typeArgs = TypeResolver.resolveRawArguments(RelationshipRepository.class, relRepository.getClass());
            Class sourceResourceClass = typeArgs[0];
            Class targetResourceClass = typeArgs[2];
            module.addRepository(sourceResourceClass, targetResourceClass, relRepository);
        } else if (repository instanceof ResourceRepositoryV2) {
            ResourceRepositoryV2 resRepository = (ResourceRepositoryV2)repository;
            module.addRepository(resRepository.getResourceClass(), resRepository);
        } else if (repository instanceof RelationshipRepositoryV2) {
            RelationshipRepositoryV2 relRepository = (RelationshipRepositoryV2)repository;
            module.addRepository(relRepository.getSourceResourceClass(), relRepository.getTargetResourceClass(), relRepository);
        } else {
            throw new IllegalStateException(repository.toString());
        }
    }

    private void addModules() {
        List<Module> modules = this.serviceDiscovery.getInstancesByType(Module.class);
        for (Module module : modules) {
            this.moduleRegistry.addModule(module);
        }
    }

    private void setupServiceUrlProvider() {
        if (this.serviceUrlProvider == null) {
            String resourceDefaultDomain = this.propertiesProvider.getProperty("crnk.config.core.resource.domain");
            String webPathPrefix = this.getWebPathPrefix();
            if (resourceDefaultDomain != null) {
                String serviceUrl = CrnkBoot.buildServiceUrl(resourceDefaultDomain, webPathPrefix);
                this.serviceUrlProvider = new ConstantServiceUrlProvider(serviceUrl);
            } else {
                this.serviceUrlProvider = this.defaultServiceUrlProvider;
            }
        }
        PreconditionUtil.assertNotNull("expected serviceUrlProvider", this.serviceUrlProvider);
    }

    public HttpRequestProcessorImpl getRequestDispatcher() {
        PreconditionUtil.assertNotNull("expected requestDispatcher", this.requestDispatcher);
        return this.requestDispatcher;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNull("ObjectMapper already set", this.objectMapper);
        this.objectMapper = objectMapper;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.checkNotConfiguredYet();
        this.propertiesProvider = propertiesProvider;
    }

    public void setResourceFieldNameTransformer(ResourceFieldNameTransformer resourceFieldNameTransformer) {
        this.checkNotConfiguredYet();
        this.resourceFieldNameTransformer = resourceFieldNameTransformer;
    }

    public ServiceUrlProvider getDefaultServiceUrlProvider() {
        return this.defaultServiceUrlProvider;
    }

    public void setDefaultServiceUrlProvider(ServiceUrlProvider defaultServiceUrlProvider) {
        this.defaultServiceUrlProvider = defaultServiceUrlProvider;
    }

    public String getWebPathPrefix() {
        return this.propertiesProvider.getProperty("crnk.config.web.path.prefix");
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.moduleRegistry.getServiceDiscovery();
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        this.moduleRegistry.setServiceDiscovery(serviceDiscovery);
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        PreconditionUtil.assertNotNull("Setting the default page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.querySpecDeserializer);
        ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setDefaultLimit(defaultPageLimit);
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        PreconditionUtil.assertNotNull("Setting the max page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.querySpecDeserializer);
        ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setMaxPageLimit(maxPageLimit);
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        return this.querySpecDeserializer;
    }

    public void setQuerySpecDeserializer(QuerySpecDeserializer querySpecDeserializer) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query spec deserializer must be provided, but is null", querySpecDeserializer);
        this.querySpecDeserializer = querySpecDeserializer;
        this.queryParamsBuilder = null;
    }

    public boolean isNullDataResponseEnabled() {
        return Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.null.data.response.enabled"));
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }
}

