/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.path;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.path.ActionPath;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PathBuilder {
    public static final String SEPARATOR = "/";
    public static final String RELATIONSHIP_MARK = "relationships";
    private final ResourceRegistry resourceRegistry;

    public PathBuilder(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    private static PathIds createPathIds(String idsString) {
        List<String> pathIds = Arrays.asList(idsString.split(",|%2C"));
        return new PathIds(pathIds);
    }

    private static String[] splitPath(String path) {
        if (path.startsWith(SEPARATOR)) {
            path = path.substring(1);
        }
        if (path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length());
        }
        return path.split(SEPARATOR);
    }

    public static String build(JsonPath jsonPath) {
        LinkedList<String> urlParts = new LinkedList<String>();
        JsonPath currentJsonPath = jsonPath;
        do {
            String pathPart;
            if (currentJsonPath instanceof RelationshipsPath) {
                pathPart = "relationships/" + currentJsonPath.getElementName();
            } else if (currentJsonPath instanceof FieldPath) {
                pathPart = currentJsonPath.getElementName();
            } else {
                pathPart = currentJsonPath.getElementName();
                if (currentJsonPath.getIds() != null) {
                    pathPart = pathPart + SEPARATOR + PathBuilder.mergeIds(currentJsonPath.getIds());
                }
            }
            urlParts.add(pathPart);
        } while ((currentJsonPath = currentJsonPath.getParentResource()) != null);
        Collections.reverse(urlParts);
        return SEPARATOR + StringUtils.join(SEPARATOR, urlParts) + SEPARATOR;
    }

    private static String mergeIds(PathIds ids) {
        return StringUtils.join(",", ids.getIds());
    }

    public JsonPath build(String path) {
        String[] strings = PathBuilder.splitPath(path);
        if (strings.length == 0 || strings.length == 1 && "".equals(strings[0])) {
            throw new ResourceException("Path is empty");
        }
        JsonPath previousJsonPath = null;
        JsonPath currentJsonPath = null;
        int currentElementIdx = 0;
        while (currentElementIdx < strings.length) {
            String elementName = null;
            PathIds pathIds = null;
            String actionName = null;
            boolean relationshipMark = false;
            if (RELATIONSHIP_MARK.equals(strings[currentElementIdx])) {
                relationshipMark = true;
                ++currentElementIdx;
            }
            RegistryEntry entry = null;
            if (currentElementIdx < strings.length && !RELATIONSHIP_MARK.equals(strings[currentElementIdx])) {
                elementName = strings[currentElementIdx];
                StringBuilder potentialResourceType = new StringBuilder();
                int i = 0;
                while (currentElementIdx + i < strings.length) {
                    if (potentialResourceType.length() > 0) {
                        potentialResourceType.append(SEPARATOR);
                    }
                    potentialResourceType.append(strings[currentElementIdx + i]);
                    entry = this.resourceRegistry.getEntry(potentialResourceType.toString());
                    if (entry != null) {
                        currentElementIdx += i;
                        elementName = potentialResourceType.toString();
                        break;
                    }
                    ++i;
                }
                ++currentElementIdx;
            }
            if (currentElementIdx < strings.length && entry != null && entry.getRepositoryInformation().getActions().containsKey(strings[currentElementIdx])) {
                actionName = strings[currentElementIdx];
                ++currentElementIdx;
            } else if (currentElementIdx < strings.length && !RELATIONSHIP_MARK.equals(strings[currentElementIdx])) {
                pathIds = PathBuilder.createPathIds(strings[currentElementIdx]);
                if (++currentElementIdx < strings.length && entry != null && entry.getRepositoryInformation().getActions().containsKey(strings[currentElementIdx])) {
                    actionName = strings[currentElementIdx];
                    ++currentElementIdx;
                }
            }
            if (previousJsonPath != null) {
                currentJsonPath = this.getNonResourcePath(previousJsonPath, elementName, relationshipMark);
                if (pathIds != null) {
                    throw new ResourceException("RelationshipsPath and FieldPath cannot contain ids");
                }
            } else if (entry != null && !relationshipMark) {
                currentJsonPath = new ResourcePath(elementName);
            } else {
                return null;
            }
            if (pathIds != null) {
                currentJsonPath.setIds(pathIds);
            }
            if (actionName != null) {
                ActionPath actionPath = new ActionPath(actionName);
                actionPath.setParentResource(currentJsonPath);
                currentJsonPath = actionPath;
            }
            if (previousJsonPath != null) {
                currentJsonPath.setParentResource(previousJsonPath);
            }
            previousJsonPath = currentJsonPath;
        }
        return currentJsonPath;
    }

    private JsonPath getNonResourcePath(JsonPath previousJsonPath, String elementName, boolean relationshipMark) {
        String previousElementName = previousJsonPath.getElementName();
        RegistryEntry previousEntry = this.resourceRegistry.getEntry(previousElementName);
        ResourceInformation resourceInformation = previousEntry.getResourceInformation();
        List<ResourceField> resourceFields = resourceInformation.getRelationshipFields();
        for (ResourceField field : resourceFields) {
            if (!field.getJsonName().equals(elementName)) continue;
            if (relationshipMark) {
                return new RelationshipsPath(elementName);
            }
            return new FieldPath(elementName);
        }
        throw new ResourceFieldNotFoundException(elementName);
    }
}

