/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryImpl
implements ResourceRegistry {
    private final Map<String, RegistryEntry> resourcesByType;
    private final Map<Class, RegistryEntry> resourcesByClass;
    private final ServiceUrlProvider serviceUrlProvider;
    private final Logger logger = LoggerFactory.getLogger(ResourceRegistryImpl.class);
    private ModuleRegistry moduleRegistry;
    private ConcurrentHashMap<String, ResourceInformation> baseTypeCache = new ConcurrentHashMap();

    public ResourceRegistryImpl(ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrlProvider) {
        this.moduleRegistry = moduleRegistry;
        this.serviceUrlProvider = serviceUrlProvider;
        this.resourcesByType = new HashMap<String, RegistryEntry>();
        this.resourcesByClass = new HashMap<Class, RegistryEntry>();
        this.moduleRegistry.setResourceRegistry(this);
    }

    @Override
    public RegistryEntry addEntry(Class<?> resource, RegistryEntry registryEntry) {
        this.resourcesByClass.put(resource, registryEntry);
        this.resourcesByType.put(registryEntry.getResourceInformation().getResourceType(), registryEntry);
        registryEntry.initialize(this.moduleRegistry);
        this.logger.debug("Added resource {} to ResourceRegistry", (Object)resource.getName());
        return registryEntry;
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.resourcesByType.get(resourceType);
    }

    @Override
    public RegistryEntry findEntry(Class<?> clazz) {
        return this.findEntry(clazz, false);
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.findEntry(clazz, true) != null;
    }

    protected RegistryEntry findEntry(Class<?> clazz, boolean allowNull) {
        Optional<Class<?>> resourceClazz = this.getResourceClass(clazz);
        if (allowNull && !resourceClazz.isPresent()) {
            return null;
        }
        if (!resourceClazz.isPresent()) {
            throw new RepositoryNotFoundException(clazz.getCanonicalName());
        }
        return this.resourcesByClass.get(resourceClazz.get());
    }

    public Optional<Class<?>> getResourceClass(Object resource) {
        return this.getResourceClass(resource.getClass());
    }

    public Optional<Class<?>> getResourceClass(Class<?> resourceClass) {
        for (Class<?> currentClass = resourceClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            RegistryEntry entry = this.resourcesByClass.get(currentClass);
            if (entry == null) continue;
            return Optional.of(currentClass);
        }
        return Optional.empty();
    }

    @Override
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public Set<RegistryEntry> getResources() {
        return Collections.unmodifiableSet(new HashSet<RegistryEntry>(this.resourcesByType.values()));
    }

    @Override
    @Deprecated
    public RegistryEntry getEntryForClass(Class<?> resourceClass) {
        return this.getEntry(resourceClass);
    }

    @Override
    public RegistryEntry getEntry(Class<?> resourceClass) {
        return this.resourcesByClass.get(resourceClass);
    }

    @Override
    public String getResourceUrl(ResourceInformation resourceInformation) {
        String url = UrlUtils.removeTrailingSlash(this.serviceUrlProvider.getUrl());
        return url + "/" + resourceInformation.getResourceType();
    }

    @Override
    public ResourceInformation getBaseResourceInformation(String resourceType) {
        ResourceInformation baseInformation = this.baseTypeCache.get(resourceType);
        if (baseInformation != null) {
            return baseInformation;
        }
        RegistryEntry entry = this.getEntry(resourceType);
        baseInformation = entry.getResourceInformation();
        while (baseInformation.getSuperResourceType() != null) {
            entry = this.getEntry(baseInformation.getSuperResourceType());
            baseInformation = entry.getResourceInformation();
        }
        this.baseTypeCache.put(resourceType, baseInformation);
        return baseInformation;
    }
}

