/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryBulkRequestFilterChain;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.filter.RepositoryLinksFilterChain;
import io.crnk.core.engine.filter.RepositoryMetaFilterChain;
import io.crnk.core.engine.filter.RepositoryRequestFilterChain;
import io.crnk.core.engine.filter.RepositoryResultFilterChain;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.JsonApiUrlBuilder;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.LinksRepositoryV2;
import io.crnk.core.repository.MetaRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.links.DefaultPagedLinksInformation;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.PagedLinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.legacy.internal.AnnotatedRepositoryAdapter;
import io.crnk.legacy.repository.LinksRepository;
import io.crnk.legacy.repository.MetaRepository;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ResponseRepositoryAdapter {
    protected ResourceInformation resourceInformation;
    protected ModuleRegistry moduleRegistry;

    public ResponseRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.resourceInformation = resourceInformation;
    }

    protected <T> Iterable<T> filterResult(Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryResultFilterChainImpl chain = new RepositoryResultFilterChainImpl(resources);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    protected JsonApiResponse getResponse(Object repository, Object result, RepositoryRequestSpec requestSpec) {
        Iterable resultEntity;
        if (result instanceof JsonApiResponse) {
            return (JsonApiResponse)result;
        }
        boolean isCollection = result instanceof Iterable;
        List<Object> resources = isCollection ? (List<Object>)result : Collections.singletonList(result);
        Iterable filteredResult = this.filterResult(resources, requestSpec);
        MetaInformation metaInformation = this.getMetaInformation(repository, resources, requestSpec);
        LinksInformation linksInformation = this.getLinksInformation(repository, resources, requestSpec);
        if (isCollection) {
            resultEntity = filteredResult;
        } else {
            Iterator iterator = filteredResult.iterator();
            if (iterator.hasNext()) {
                resultEntity = iterator.next();
                PreconditionUtil.assertFalse("expected unique result", iterator.hasNext());
            } else {
                resultEntity = null;
            }
        }
        return new JsonApiResponse().setEntity(resultEntity).setLinksInformation(linksInformation).setMetaInformation(metaInformation);
    }

    private MetaInformation getMetaInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryMetaFilterChainImpl chain = new RepositoryMetaFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    private MetaInformation doGetMetaInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            return resourceList.getMeta();
        }
        QueryAdapter queryAdapter = requestSpec.getQueryAdapter();
        if (repository instanceof AnnotatedRepositoryAdapter) {
            if (((AnnotatedRepositoryAdapter)repository).metaRepositoryAvailable()) {
                return ((AnnotatedRepositoryAdapter)repository).getMetaInformation(resources, queryAdapter);
            }
        } else {
            if (repository instanceof MetaRepositoryV2) {
                return ((MetaRepositoryV2)repository).getMetaInformation(resources, requestSpec.getQuerySpec(this.getResourceInformation(repository)));
            }
            if (repository instanceof MetaRepository) {
                return ((MetaRepository)repository).getMetaInformation(resources, requestSpec.getQueryParams());
            }
        }
        return null;
    }

    private LinksInformation getLinksInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryLinksFilterChainImpl chain = new RepositoryLinksFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    protected RepositoryFilterContext newRepositoryFilterContext(final RepositoryRequestSpec requestSpec) {
        return new RepositoryFilterContext(){

            @Override
            public RepositoryRequestSpec getRequest() {
                return requestSpec;
            }
        };
    }

    private LinksInformation doGetLinksInformation(Object repository, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            boolean createLinksInformation = resourceList instanceof DefaultResourceList;
            LinksInformation newLinksInfo = this.enrichLinksInformation(resourceList.getLinks(), resources, requestSpec);
            if (createLinksInformation) {
                ((DefaultResourceList)resources).setLinks(newLinksInfo);
            }
            return resourceList.getLinks();
        }
        LinksInformation linksInformation = null;
        if (repository instanceof AnnotatedRepositoryAdapter) {
            if (((AnnotatedRepositoryAdapter)repository).linksRepositoryAvailable()) {
                linksInformation = ((LinksRepository)repository).getLinksInformation(resources, requestSpec.getQueryParams());
            }
        } else if (repository instanceof LinksRepositoryV2) {
            linksInformation = ((LinksRepositoryV2)repository).getLinksInformation(resources, requestSpec.getQuerySpec(this.getResourceInformation(repository)));
        } else if (repository instanceof LinksRepository) {
            linksInformation = ((LinksRepository)repository).getLinksInformation(resources, requestSpec.getQueryParams());
        }
        return this.enrichLinksInformation(linksInformation, resources, requestSpec);
    }

    private LinksInformation enrichLinksInformation(LinksInformation linksInformation, Iterable<?> resources, RepositoryRequestSpec requestSpec) {
        QueryAdapter queryAdapter = requestSpec.getQueryAdapter();
        LinksInformation enrichedLinksInformation = linksInformation;
        if (queryAdapter instanceof QuerySpecAdapter && (queryAdapter.getOffset() != 0L || queryAdapter.getLimit() != null)) {
            enrichedLinksInformation = this.enrichPageLinksInformation(enrichedLinksInformation, resources, queryAdapter, requestSpec);
        }
        return enrichedLinksInformation;
    }

    private LinksInformation enrichPageLinksInformation(LinksInformation linksInformation, Iterable<?> resources, QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec) {
        if (linksInformation == null) {
            linksInformation = new DefaultPagedLinksInformation();
        }
        if (linksInformation instanceof PagedLinksInformation) {
            Long totalCount = this.getTotalCount(resources);
            PagedLinksInformation pagedLinksInformation = (PagedLinksInformation)linksInformation;
            if (totalCount != null && !this.hasPageLinks(pagedLinksInformation)) {
                this.doEnrichPageLinksInformation(pagedLinksInformation, totalCount, queryAdapter, requestSpec);
            }
        }
        return linksInformation;
    }

    private Long getTotalCount(Iterable<?> resources) {
        ResourceList list;
        PagedMetaInformation pagedMeta;
        if (resources instanceof ResourceList && (pagedMeta = (list = (ResourceList)resources).getMeta(PagedMetaInformation.class)) != null) {
            return pagedMeta.getTotalResourceCount();
        }
        return null;
    }

    private boolean hasPageLinks(PagedLinksInformation pagedLinksInformation) {
        return pagedLinksInformation.getFirst() != null || pagedLinksInformation.getLast() != null || pagedLinksInformation.getPrev() != null || pagedLinksInformation.getNext() != null;
    }

    private void doEnrichPageLinksInformation(PagedLinksInformation pagedLinksInformation, long total, QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec) {
        long pageSize = queryAdapter.getLimit();
        long offset = queryAdapter.getOffset();
        long currentPage = offset / pageSize;
        if (currentPage * pageSize != offset) {
            throw new BadRequestException("offset " + offset + " is not a multiple of limit " + pageSize);
        }
        long totalPages = (total + pageSize - 1L) / pageSize;
        QueryAdapter pageSpec = queryAdapter.duplicate();
        pageSpec.setLimit(pageSize);
        if (totalPages > 0L) {
            pageSpec.setOffset(0L);
            pagedLinksInformation.setFirst(this.toUrl(pageSpec, requestSpec));
            pageSpec.setOffset((totalPages - 1L) * pageSize);
            pagedLinksInformation.setLast(this.toUrl(pageSpec, requestSpec));
            if (currentPage > 0L) {
                pageSpec.setOffset((currentPage - 1L) * pageSize);
                pagedLinksInformation.setPrev(this.toUrl(pageSpec, requestSpec));
            }
            if (currentPage < totalPages - 1L) {
                pageSpec.setOffset((currentPage + 1L) * pageSize);
                pagedLinksInformation.setNext(this.toUrl(pageSpec, requestSpec));
            }
        }
    }

    private String toUrl(QueryAdapter queryAdapter, RepositoryRequestSpec requestSpec) {
        JsonApiUrlBuilder urlBuilder = new JsonApiUrlBuilder(this.moduleRegistry.getResourceRegistry());
        Serializable relationshipSourceId = requestSpec.getId();
        ResourceField relationshipField = requestSpec.getRelationshipField();
        ResourceInformation rootInfo = relationshipField == null ? queryAdapter.getResourceInformation() : relationshipField.getParentResourceInformation();
        return urlBuilder.buildUrl(rootInfo, (Object)relationshipSourceId, queryAdapter, relationshipField != null ? relationshipField.getJsonName() : null);
    }

    protected abstract ResourceInformation getResourceInformation(Object var1);

    protected abstract class RepositoryBulkRequestFilterChainImpl<K>
    implements RepositoryBulkRequestFilterChain<K> {
        protected int filterIndex = 0;

        protected RepositoryBulkRequestFilterChainImpl() {
        }

        @Override
        public Map<K, JsonApiResponse> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterBulkRequest(context, this);
        }

        protected abstract Map<K, JsonApiResponse> invoke(RepositoryFilterContext var1);
    }

    protected abstract class RepositoryRequestFilterChainImpl
    implements RepositoryRequestFilterChain {
        protected int filterIndex = 0;

        protected RepositoryRequestFilterChainImpl() {
        }

        @Override
        public JsonApiResponse doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterRequest(context, this);
        }

        protected abstract JsonApiResponse invoke(RepositoryFilterContext var1);
    }

    class RepositoryResultFilterChainImpl<T>
    implements RepositoryResultFilterChain<T> {
        protected int filterIndex = 0;
        private Iterable<T> result;

        public RepositoryResultFilterChainImpl(Iterable<T> result) {
            this.result = result;
        }

        @Override
        public Iterable<T> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.result;
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterResult(context, this);
        }
    }

    class RepositoryLinksFilterChainImpl
    implements RepositoryLinksFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryLinksFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> LinksInformation doFilter(RepositoryFilterContext context, Iterable<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetLinksInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterLinks(context, resources, this);
        }
    }

    class RepositoryMetaFilterChainImpl
    implements RepositoryMetaFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryMetaFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> MetaInformation doFilter(RepositoryFilterContext context, Iterable<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetMetaInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterMeta(context, resources, this);
        }
    }
}

