/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ResourcePatch
extends ResourceUpsert {
    public ResourcePatch(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper) {
        super(resourceRegistry, propertiesProvider, typeParser, objectMapper, documentMapper);
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        return !jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.PATCH.name().equals(requestType);
    }

    @Override
    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestDocument) {
        RegistryEntry endpointRegistryEntry = this.getRegistryEntry(jsonPath);
        final Resource resourceBody = this.getRequestBody(requestDocument, jsonPath, HttpMethod.PATCH);
        RegistryEntry bodyRegistryEntry = this.resourceRegistry.getEntry(resourceBody.getType());
        String idString = jsonPath.getIds().getIds().get(0);
        ResourceInformation resourceInformation = bodyRegistryEntry.getResourceInformation();
        Serializable resourceId = resourceInformation.parseIdString(idString);
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository(parameterProvider);
        JsonApiResponse resourceFindResponse = resourceRepository.findOne(resourceId, queryAdapter);
        Object resource = this.extractResource(resourceFindResponse);
        if (resource == null) {
            throw new ResourceNotFoundException(jsonPath.toString());
        }
        final Resource resourceFindData = this.documentMapper.toDocument(resourceFindResponse, queryAdapter, parameterProvider).getSingleData().get();
        resourceInformation.verify(resource, requestDocument);
        ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String attributesFromFindOne = ResourcePatch.this.extractAttributesFromResourceAsJson(resourceFindData);
                HashMap attributesToUpdate = new HashMap(ResourcePatch.this.emptyIfNull((Map)ResourcePatch.this.objectMapper.readValue(attributesFromFindOne, Map.class)));
                String attributesAsJson = ResourcePatch.this.objectMapper.writeValueAsString(resourceBody.getAttributes());
                Map attributesFromRequest = ResourcePatch.this.emptyIfNull((Map)ResourcePatch.this.objectMapper.readValue(attributesAsJson, Map.class));
                Iterator it = attributesToUpdate.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (attributesFromRequest.containsKey(key)) continue;
                    it.remove();
                }
                ResourcePatch.this.updateValues(attributesToUpdate, attributesFromRequest);
                HashMap<String, JsonNode> upsertedAttributes = new HashMap<String, JsonNode>();
                for (Map.Entry entry : attributesToUpdate.entrySet()) {
                    JsonNode value = ResourcePatch.this.objectMapper.valueToTree(entry.getValue());
                    upsertedAttributes.put((String)entry.getKey(), value);
                }
                resourceBody.setAttributes(upsertedAttributes);
                return null;
            }
        }, "failed to merge patched attributes", new Object[0]);
        this.setAttributes(resourceBody, resource, bodyRegistryEntry.getResourceInformation());
        this.setRelations(resource, bodyRegistryEntry, resourceBody, queryAdapter, parameterProvider);
        Set<String> loadedRelationshipNames = this.getLoadedRelationshipNames(resourceBody);
        JsonApiResponse updatedResource = resourceRepository.update(resource, queryAdapter);
        Document responseDocument = this.documentMapper.toDocument(updatedResource, queryAdapter, parameterProvider, loadedRelationshipNames);
        return new Response(responseDocument, 200);
    }

    private <K, V> Map<K, V> emptyIfNull(Map<K, V> value) {
        return value != null ? value : Collections.emptyMap();
    }

    private String extractAttributesFromResourceAsJson(Resource resource) throws IOException {
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        String newRequestBody = this.objectMapper.writeValueAsString((Object)resource);
        JsonNode node = this.objectMapper.readTree(newRequestBody);
        JsonNode attributes = node.findValue("attributes");
        return this.objectMapper.writeValueAsString((Object)attributes);
    }

    private void updateValues(Map<String, Object> source, Map<String, Object> updates) {
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            String fieldName = entry.getKey();
            Object updatedValue = entry.getValue();
            if (updatedValue instanceof Map) {
                if (source.get(fieldName) == null) {
                    source.put(fieldName, new HashMap());
                }
                Object sourceMap = source.get(fieldName);
                this.updateValues((Map)sourceMap, (Map)updatedValue);
                continue;
            }
            source.put(fieldName, updatedValue);
        }
    }

    @Override
    protected boolean canModifyField(ResourceInformation resourceInformation, String fieldName, ResourceField field) {
        return field == null || field.getAccess().isPostable();
    }
}

