/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.legacy.queryParams.DefaultQueryParamsConverter;
import io.crnk.legacy.queryParams.QueryParams;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class QuerySpecAdapter
implements QueryAdapter {
    private QuerySpec querySpec;
    private ResourceRegistry resourceRegistry;

    public QuerySpecAdapter(QuerySpec querySpec, ResourceRegistry resourceRegistry) {
        this.querySpec = querySpec;
        this.resourceRegistry = resourceRegistry;
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    @Override
    public TypedParams<IncludedRelationsParams> getIncludedRelations() {
        HashMap<String, IncludedRelationsParams> params = new HashMap<String, IncludedRelationsParams>();
        this.addRelations(params, this.querySpec);
        for (QuerySpec relatedSpec : this.querySpec.getRelatedSpecs().values()) {
            this.addRelations(params, relatedSpec);
        }
        return new TypedParams<IncludedRelationsParams>(params);
    }

    private void addRelations(Map<String, IncludedRelationsParams> params, QuerySpec spec) {
        if (!spec.getIncludedRelations().isEmpty()) {
            HashSet<Inclusion> set = new HashSet<Inclusion>();
            for (IncludeRelationSpec relation : spec.getIncludedRelations()) {
                set.add(new Inclusion(StringUtils.join(".", relation.getAttributePath())));
            }
            params.put(this.getResourceTypee(spec), new IncludedRelationsParams(set));
        }
    }

    private String getResourceTypee(QuerySpec spec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(spec.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.getResourceType();
    }

    @Override
    public TypedParams<IncludedFieldsParams> getIncludedFields() {
        HashMap<String, IncludedFieldsParams> params = new HashMap<String, IncludedFieldsParams>();
        this.addFields(params, this.querySpec);
        for (QuerySpec relatedSpec : this.querySpec.getRelatedSpecs().values()) {
            this.addFields(params, relatedSpec);
        }
        return new TypedParams<IncludedFieldsParams>(params);
    }

    private void addFields(Map<String, IncludedFieldsParams> params, QuerySpec spec) {
        if (!spec.getIncludedFields().isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            for (IncludeFieldSpec relation : spec.getIncludedFields()) {
                set.add(StringUtils.join(".", relation.getAttributePath()));
            }
            params.put(this.getResourceTypee(spec), new IncludedFieldsParams(set));
        }
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceRegistry.findEntry(this.querySpec.getResourceClass()).getResourceInformation();
    }

    @Override
    public Long getLimit() {
        return this.querySpec.getLimit();
    }

    @Override
    public void setLimit(Long limit) {
        this.querySpec.setLimit(limit);
    }

    @Override
    public long getOffset() {
        return this.querySpec.getOffset();
    }

    @Override
    public void setOffset(long offset) {
        this.querySpec.setOffset(offset);
    }

    @Override
    public QueryAdapter duplicate() {
        return new QuerySpecAdapter(this.querySpec.duplicate(), this.resourceRegistry);
    }

    @Override
    public QueryParams toQueryParams() {
        DefaultQueryParamsConverter converter = new DefaultQueryParamsConverter(this.resourceRegistry);
        return converter.fromParams(this.getResourceInformation().getResourceClass(), this.getQuerySpec());
    }

    @Override
    public QuerySpec toQuerySpec() {
        return this.getQuerySpec();
    }
}

