/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;

public abstract class BaseController {
    public abstract boolean isAcceptable(JsonPath var1, String var2);

    public abstract Response handle(JsonPath var1, QueryAdapter var2, RepositoryMethodParameterProvider var3, Document var4);

    protected void verifyTypes(HttpMethod methodType, String resourceEndpointName, RegistryEntry endpointRegistryEntry, RegistryEntry bodyRegistryEntry) {
        if (endpointRegistryEntry.equals(bodyRegistryEntry)) {
            return;
        }
        if (bodyRegistryEntry == null || !bodyRegistryEntry.isParent(endpointRegistryEntry)) {
            String message = String.format("Inconsistent type definition between path and body: body type: %s, request type: %s", new Object[]{methodType, resourceEndpointName});
            throw new RequestBodyException(methodType, resourceEndpointName, message);
        }
    }

    protected Object extractResource(Object responseOrResource) {
        if (responseOrResource instanceof JsonApiResponse) {
            return ((JsonApiResponse)responseOrResource).getEntity();
        }
        return responseOrResource;
    }
}

