/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.Collections;

public abstract class RelationshipsResourceUpsert
extends ResourceIncludeField {
    RelationshipsResourceUpsert(ResourceRegistry resourceRegistry, TypeParser typeParser, DocumentMapper documentMapper) {
        super(resourceRegistry, typeParser, documentMapper);
    }

    protected abstract HttpMethod method();

    protected abstract void processToManyRelationship(Object var1, Class<? extends Serializable> var2, ResourceField var3, Iterable<ResourceIdentifier> var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    protected abstract void processToOneRelationship(Object var1, Class<? extends Serializable> var2, ResourceField var3, ResourceIdentifier var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    @Override
    public final boolean isAcceptable(JsonPath jsonPath, String requestType) {
        PreconditionUtil.assertNotNull("jsonPath cannot be null", jsonPath);
        return !jsonPath.isCollection() && RelationshipsPath.class.equals(jsonPath.getClass()) && this.method().name().equals(requestType);
    }

    @Override
    public final Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        String resourceName = jsonPath.getResourceType();
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.getRegistryEntry(resourceName);
        this.assertRequestDocument(requestBody, HttpMethod.POST, resourceName);
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(jsonPath.getElementName());
        if (relationshipField == null) {
            throw new ResourceFieldNotFoundException(jsonPath.getElementName());
        }
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        Object resource = this.extractResource(resourceRepository.findOne(castedResourceId, queryAdapter));
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        Class<?> relationshipFieldClass = ClassUtils.getResourceClass(relationshipField.getGenericType(), baseRelationshipFieldClass);
        Class<?> relationshipIdType = this.resourceRegistry.findEntry(relationshipFieldClass).getResourceInformation().getIdField().getType();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepositoryForClass(relationshipFieldClass, parameterProvider);
        if (Iterable.class.isAssignableFrom(baseRelationshipFieldClass)) {
            Iterable dataBodies = requestBody.isMultiple() ? requestBody.getData().get() : Collections.singletonList(requestBody.getData().get());
            this.processToManyRelationship(resource, relationshipIdType, relationshipField, dataBodies, queryAdapter, relationshipRepositoryForClass);
        } else {
            if (requestBody.isMultiple()) {
                throw new RequestBodyException(HttpMethod.POST, resourceName, "Multiple data in body");
            }
            ResourceIdentifier dataBody = (ResourceIdentifier)requestBody.getData().get();
            this.processToOneRelationship(resource, relationshipIdType, relationshipField, dataBody, queryAdapter, relationshipRepositoryForClass);
        }
        return new Response(new Document(), 204);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        return this.typeParser.parse(resourceId, idClass);
    }
}

