/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.IncludeBehavior;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncludeLookupUtil {
    private ResourceRegistry resourceRegistry;
    private IncludeBehavior includeBehavior;

    public IncludeLookupUtil(ResourceRegistry resourceRegistry, IncludeBehavior includeBehavior) {
        this.resourceRegistry = resourceRegistry;
        this.includeBehavior = includeBehavior;
    }

    public static LookupIncludeBehavior getDefaultLookupIncludeBehavior(PropertiesProvider propertiesProvider) {
        if (propertiesProvider == null) {
            return LookupIncludeBehavior.NONE;
        }
        String includeAutomaticallyString = propertiesProvider.getProperty("crnk.config.include.automatically");
        boolean includeAutomatically = Boolean.parseBoolean(includeAutomaticallyString);
        String includeAutomaticallyOverwriteString = propertiesProvider.getProperty("crnk.config.include.automatically.overwrite");
        boolean includeAutomaticallyOverwrite = Boolean.parseBoolean(includeAutomaticallyOverwriteString);
        if (includeAutomaticallyOverwrite) {
            return LookupIncludeBehavior.AUTOMATICALLY_ALWAYS;
        }
        if (includeAutomatically) {
            return LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL;
        }
        return LookupIncludeBehavior.NONE;
    }

    public static IncludeBehavior getIncludeBehavior(PropertiesProvider propertiesProvider) {
        String property;
        String string = property = propertiesProvider != null ? propertiesProvider.getProperty("crnk.config.include.behavior") : null;
        if (property == null || property.isEmpty()) {
            return IncludeBehavior.PER_TYPE;
        }
        return IncludeBehavior.valueOf(property.toUpperCase());
    }

    public Set<ResourceField> getRelationshipFields(Collection<Resource> resources) {
        HashSet<ResourceField> fields = new HashSet<ResourceField>();
        HashSet<String> processedTypes = new HashSet<String>();
        for (Resource resource : resources) {
            this.process(resource.getType(), processedTypes, fields);
        }
        return fields;
    }

    private void process(String type, Set<String> processedTypes, Set<ResourceField> fields) {
        if (!processedTypes.contains(type)) {
            processedTypes.add(type);
            RegistryEntry entry = this.resourceRegistry.getEntry(type);
            ResourceInformation information = entry.getResourceInformation();
            ResourceInformation superInformation = this.getSuperInformation(information);
            if (superInformation != null) {
                this.process(superInformation.getResourceType(), processedTypes, fields);
            }
            for (ResourceField field : information.getRelationshipFields()) {
                boolean existsOnSuperType = superInformation != null && superInformation.findRelationshipFieldByName(field.getJsonName()) != null;
                if (existsOnSuperType) continue;
                fields.add(field);
            }
        }
    }

    private ResourceInformation getSuperInformation(ResourceInformation information) {
        Class<?> resourceClass = information.getResourceClass();
        Class<?> superclass = resourceClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        boolean hasSuperType = this.resourceRegistry.hasEntry(superclass);
        return hasSuperType ? this.resourceRegistry.findEntry(superclass).getResourceInformation() : null;
    }

    public List<Resource> filterByType(Collection<Resource> resources, ResourceInformation resourceInformation) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (!this.isInstance(resourceInformation, resource)) continue;
            results.add(resource);
        }
        return results;
    }

    private boolean isInstance(ResourceInformation desiredResourceInformation, Resource resource) {
        ResourceInformation actualResourceInformation;
        if (desiredResourceInformation.getResourceType().equals(resource.getType())) {
            return true;
        }
        ResourceInformation superInformation = actualResourceInformation = this.resourceRegistry.getEntry(resource.getType()).getResourceInformation();
        while ((superInformation = this.getSuperInformation(superInformation)) != null) {
            if (!superInformation.equals(desiredResourceInformation)) continue;
            return true;
        }
        return false;
    }

    public boolean isInclusionRequested(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        if (queryAdapter == null || queryAdapter.getIncludedRelations() == null || queryAdapter.getIncludedRelations().getParams() == null) {
            return false;
        }
        if (queryAdapter instanceof QuerySpecAdapter) {
            return this.isInclusionRequestedForQueryspec(queryAdapter, fieldPath);
        }
        return this.isInclusionRequestedForQueryParams(queryAdapter, fieldPath);
    }

    private boolean isInclusionRequestedForQueryspec(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        QuerySpec querySpec = ((QuerySpecAdapter)queryAdapter).getQuerySpec();
        if (this.includeBehavior == IncludeBehavior.PER_ROOT_PATH) {
            return this.contains(querySpec, this.toPathList(fieldPath, 0));
        }
        for (int i = fieldPath.size() - 1; i >= 0; --i) {
            List<String> path = this.toPathList(fieldPath, i);
            ResourceInformation rootInformation = fieldPath.get(i).getParentResourceInformation();
            QuerySpec rootQuerySpec = querySpec.getQuerySpec(rootInformation.getResourceClass());
            if (rootQuerySpec == null || !this.contains(rootQuerySpec, path)) continue;
            return true;
        }
        return this.contains(querySpec, this.toPathList(fieldPath, 0));
    }

    private boolean isInclusionRequestedForQueryParams(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        Map<String, IncludedRelationsParams> params = queryAdapter.getIncludedRelations().getParams();
        for (int i = fieldPath.size() - 1; i >= 0; --i) {
            String path = this.toPath(fieldPath, i);
            ResourceInformation rootInformation = fieldPath.get(i).getParentResourceInformation();
            IncludedRelationsParams includedRelationsParams = params.get(rootInformation.getResourceType());
            if (includedRelationsParams == null || !this.contains(includedRelationsParams, path)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(IncludedRelationsParams includedRelationsParams, String path) {
        String pathPrefix = path + ".";
        for (Inclusion inclusion : includedRelationsParams.getParams()) {
            if (!inclusion.getPath().equals(path) && !inclusion.getPath().startsWith(pathPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(QuerySpec querySpec, List<String> path) {
        for (IncludeRelationSpec inclusion : querySpec.getIncludedRelations()) {
            if (!inclusion.getAttributePath().equals(path) && !this.startsWith(inclusion, path)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(IncludeRelationSpec inclusion, List<String> path) {
        return inclusion.getAttributePath().size() > path.size() && inclusion.getAttributePath().subList(0, path.size()).equals(path);
    }

    private String toPath(List<ResourceField> fieldPath, int offset) {
        StringBuilder builder = new StringBuilder();
        for (int i = offset; i < fieldPath.size(); ++i) {
            ResourceField field = fieldPath.get(i);
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(field.getJsonName());
        }
        return builder.toString();
    }

    private List<String> toPathList(List<ResourceField> fieldPath, int offset) {
        ArrayList<String> builder;
        ArrayList<String> result = builder = new ArrayList<String>();
        for (int i = offset; i < fieldPath.size(); ++i) {
            ResourceField field = fieldPath.get(i);
            result.add(field.getJsonName());
        }
        return result;
    }

    public List<Resource> sub(Collection<Resource> resourcesWithField, Collection<Resource> resourcesForLookup) {
        ArrayList<Resource> result = new ArrayList<Resource>(resourcesWithField);
        result.removeAll(resourcesForLookup);
        return result;
    }

    public List<Resource> filterByLoadedRelationship(List<Resource> resources, ResourceField resourceField) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (resource.getRelationships().get(resourceField.getJsonName()) == null) continue;
            results.add(resource);
        }
        return results;
    }

    public Set<ResourceIdentifier> toIds(Set<Resource> resources) {
        HashSet<ResourceIdentifier> results = new HashSet<ResourceIdentifier>();
        for (Resource resource : resources) {
            results.add(resource.toIdentifier());
        }
        return results;
    }

    public List<ResourceIdentifier> toIds(List<Resource> resources) {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (Resource resource : resources) {
            results.add(resource.toIdentifier());
        }
        return results;
    }

    public Set<Resource> union(Collection<Resource> set0, Collection<Resource> set1) {
        HashMap<ResourceIdentifier, Resource> map = new HashMap<ResourceIdentifier, Resource>();
        for (Resource resource : set0) {
            map.put(resource.toIdentifier(), resource);
        }
        for (Resource resource : set1) {
            map.put(resource.toIdentifier(), resource);
        }
        return new HashSet<Resource>(map.values());
    }

    public List<Resource> findResourcesWithoutRelationshipData(List<Resource> resources, ResourceField resourceField) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            Relationship relationship = resource.getRelationships().get(resourceField.getJsonName());
            if (relationship.getData().isPresent()) continue;
            results.add(resource);
        }
        return results;
    }
}

