/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import java.io.IOException;
import java.util.Map;

public class ErrorDataDeserializer
extends JsonDeserializer<ErrorData> {
    private static Map<String, Object> readMeta(JsonNode errorNode, JsonParser jp) throws IOException {
        JsonNode metaNode = errorNode.get("meta");
        if (metaNode != null) {
            return (Map)jp.getCodec().treeToValue((TreeNode)metaNode, Map.class);
        }
        return null;
    }

    private static String readSourcePointer(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return ErrorDataDeserializer.readStringIfExists("pointer", node);
        }
        return null;
    }

    private static String readSourceParameter(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return ErrorDataDeserializer.readStringIfExists("legacy", node);
        }
        return null;
    }

    private static String readAboutLink(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("links");
        if (node != null) {
            return ErrorDataDeserializer.readStringIfExists("about", node);
        }
        return null;
    }

    private static String readStringIfExists(String fieldName, JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get(fieldName);
        if (node != null) {
            return node.asText();
        }
        return null;
    }

    public ErrorData deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        JsonNode errorNode = (JsonNode)jp.readValueAsTree();
        if (errorNode == null) {
            return null;
        }
        String id = ErrorDataDeserializer.readStringIfExists("id", errorNode);
        String aboutLink = ErrorDataDeserializer.readAboutLink(errorNode);
        String status = ErrorDataDeserializer.readStringIfExists("status", errorNode);
        String code = ErrorDataDeserializer.readStringIfExists("code", errorNode);
        String title = ErrorDataDeserializer.readStringIfExists("title", errorNode);
        String detail = ErrorDataDeserializer.readStringIfExists("detail", errorNode);
        Map<String, Object> meta = ErrorDataDeserializer.readMeta(errorNode, jp);
        String sourcePointer = ErrorDataDeserializer.readSourcePointer(errorNode);
        String sourceParameter = ErrorDataDeserializer.readSourceParameter(errorNode);
        return new ErrorData(id, aboutLink, status, code, title, detail, sourcePointer, sourceParameter, meta);
    }

    public Class<ErrorResponse> handledType() {
        return ErrorResponse.class;
    }
}

