/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.utils.Optional;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;

public class MethodCache {
    private Map<MethodCacheKey, Optional<Method>> cache = new ConcurrentHashMap<MethodCacheKey, Optional<Method>>();

    public Optional<Method> find(Class<?> clazz, String name, Class<?> ... parameters) {
        MethodCacheKey entry = new MethodCacheKey(clazz, name, parameters);
        Optional<Method> method = this.cache.get(entry);
        if (method == null) {
            try {
                method = Optional.of(clazz.getMethod(name, parameters));
            }
            catch (NoSuchMethodException e) {
                method = Optional.empty();
            }
            this.cache.put(entry, method);
        }
        return method;
    }

    protected static class MethodCacheKey {
        private final Class<?> clazz;
        private final String name;
        private final Class[] parameters;

        public MethodCacheKey(Class<?> clazz, String name, Class<?>[] parameters) {
            this.clazz = clazz;
            this.name = name;
            this.parameters = parameters;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != MethodCacheKey.class) {
                return false;
            }
            MethodCacheKey other = (MethodCacheKey)obj;
            return ObjectUtils.equals(this.clazz, other.clazz) && ObjectUtils.equals((Object)this.name, (Object)other.name) && Arrays.equals(this.parameters, other.parameters);
        }
    }
}

