/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module;

import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.repository.RepositoryInformationBuilder;
import io.crnk.core.engine.information.resource.ResourceInformationBuilder;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleModule
implements Module {
    private List<ResourceInformationBuilder> resourceInformationBuilders = new ArrayList<ResourceInformationBuilder>();
    private List<HttpRequestProcessor> httpRequestProcessors = new ArrayList<HttpRequestProcessor>();
    private List<RepositoryInformationBuilder> repositoryInformationBuilders = new ArrayList<RepositoryInformationBuilder>();
    private List<DocumentFilter> filters = new ArrayList<DocumentFilter>();
    private List<RepositoryFilter> repositoryFilters = new ArrayList<RepositoryFilter>();
    private List<RepositoryDecoratorFactory> repositoryDecoratorFactories = new ArrayList<RepositoryDecoratorFactory>();
    private List<SecurityProvider> securityProviders = new ArrayList<SecurityProvider>();
    private List<ResourceLookup> resourceLookups = new ArrayList<ResourceLookup>();
    private List<com.fasterxml.jackson.databind.Module> jacksonModules = new ArrayList<com.fasterxml.jackson.databind.Module>();
    private List<Object> repositories = new ArrayList<Object>();
    private List<ExceptionMapperLookup> exceptionMapperLookups = new ArrayList<ExceptionMapperLookup>();
    private String moduleName;
    private Module.ModuleContext context;

    public SimpleModule(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setupModule(Module.ModuleContext context) {
        this.context = context;
        for (ResourceInformationBuilder resourceInformationBuilder : this.resourceInformationBuilders) {
            context.addResourceInformationBuilder(resourceInformationBuilder);
        }
        for (RepositoryInformationBuilder repositoryInformationBuilder : this.repositoryInformationBuilders) {
            context.addRepositoryInformationBuilder(repositoryInformationBuilder);
        }
        for (ResourceLookup resourceLookup : this.resourceLookups) {
            context.addResourceLookup(resourceLookup);
        }
        for (DocumentFilter documentFilter : this.filters) {
            context.addFilter(documentFilter);
        }
        for (RepositoryFilter repositoryFilter : this.repositoryFilters) {
            context.addRepositoryFilter(repositoryFilter);
        }
        for (RepositoryDecoratorFactory repositoryDecoratorFactory : this.repositoryDecoratorFactories) {
            context.addRepositoryDecoratorFactory(repositoryDecoratorFactory);
        }
        for (com.fasterxml.jackson.databind.Module module : this.jacksonModules) {
            context.addJacksonModule(module);
        }
        for (Object object : this.repositories) {
            context.addRepository(object);
        }
        for (ExceptionMapperLookup exceptionMapperLookup : this.exceptionMapperLookups) {
            context.addExceptionMapperLookup(exceptionMapperLookup);
        }
        for (HttpRequestProcessor httpRequestProcessor : this.httpRequestProcessors) {
            context.addHttpRequestProcessor(httpRequestProcessor);
        }
    }

    private void checkInitialized() {
        if (this.context != null) {
            throw new IllegalStateException("module cannot be changed addModule was called");
        }
    }

    public void addResourceInformationBuilder(ResourceInformationBuilder resourceInformationBuilder) {
        this.checkInitialized();
        this.resourceInformationBuilders.add(resourceInformationBuilder);
    }

    public void addRepositoryInformationBuilder(RepositoryInformationBuilder repositoryInformationBuilder) {
        this.checkInitialized();
        this.repositoryInformationBuilders.add(repositoryInformationBuilder);
    }

    public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
        this.checkInitialized();
        this.exceptionMapperLookups.add(exceptionMapperLookup);
    }

    public void addExceptionMapper(JsonApiExceptionMapper exceptionMapper) {
        this.checkInitialized();
        CollectionExceptionMapperLookup exceptionMapperLookup = new CollectionExceptionMapperLookup(exceptionMapper);
        this.exceptionMapperLookups.add(exceptionMapperLookup);
    }

    protected List<ResourceInformationBuilder> getResourceInformationBuilders() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.resourceInformationBuilders);
    }

    protected List<RepositoryInformationBuilder> getRepositoryInformationBuilders() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryInformationBuilders);
    }

    public void addFilter(DocumentFilter filter) {
        this.checkInitialized();
        this.filters.add(filter);
    }

    public void addRepositoryFilter(RepositoryFilter filter) {
        this.checkInitialized();
        this.repositoryFilters.add(filter);
    }

    public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decorator) {
        this.checkInitialized();
        this.repositoryDecoratorFactories.add(decorator);
    }

    protected List<DocumentFilter> getFilters() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.filters);
    }

    protected List<RepositoryFilter> getRepositoryFilters() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryFilters);
    }

    protected List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryDecoratorFactories);
    }

    public void addSecurityProvider(SecurityProvider securityProvider) {
        this.checkInitialized();
        this.securityProviders.add(securityProvider);
    }

    public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
        this.checkInitialized();
        this.jacksonModules.add(module);
    }

    protected List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.jacksonModules);
    }

    public void addResourceLookup(ResourceLookup resourceLookup) {
        this.checkInitialized();
        this.resourceLookups.add(resourceLookup);
    }

    protected List<ResourceLookup> getResourceLookups() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.resourceLookups);
    }

    public void addRepository(Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    @Deprecated
    public void addRepository(Class<?> resourceClass, Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    @Deprecated
    public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    public List<Object> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public List<ExceptionMapperLookup> getExceptionMapperLookups() {
        return Collections.unmodifiableList(this.exceptionMapperLookups);
    }

    public List<SecurityProvider> getSecurityProviders() {
        return Collections.unmodifiableList(this.securityProviders);
    }

    public void addHttpRequestProcessor(HttpRequestProcessor httpRequestProcessor) {
        this.httpRequestProcessors.add(httpRequestProcessor);
    }

    public List<HttpRequestProcessor> getHttpRequestProcessors() {
        return Collections.unmodifiableList(this.httpRequestProcessors);
    }

    private static class CollectionExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Set<JsonApiExceptionMapper> set;

        private CollectionExceptionMapperLookup(Set<JsonApiExceptionMapper> set) {
            this.set = set;
        }

        public CollectionExceptionMapperLookup(JsonApiExceptionMapper exceptionMapper) {
            this(new HashSet<JsonApiExceptionMapper>(Arrays.asList(exceptionMapper)));
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            return this.set;
        }
    }
}

