/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.InMemoryEvaluator;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuerySpec {
    private Class<?> resourceClass;
    private Long limit = null;
    private long offset = 0L;
    private List<FilterSpec> filters = new ArrayList<FilterSpec>();
    private List<SortSpec> sort = new ArrayList<SortSpec>();
    private List<IncludeFieldSpec> includedFields = new ArrayList<IncludeFieldSpec>();
    private List<IncludeRelationSpec> includedRelations = new ArrayList<IncludeRelationSpec>();
    private Map<Class<?>, QuerySpec> relatedSpecs = new HashMap();

    public QuerySpec(Class<?> resourceClass) {
        this.resourceClass = resourceClass;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public <T> DefaultResourceList<T> apply(Iterable<T> resources) {
        DefaultResourceList resultList = new DefaultResourceList();
        resultList.setMeta(new DefaultPagedMetaInformation());
        this.apply(resources, resultList);
        return resultList;
    }

    public <T> void apply(Iterable<T> resources, ResourceList<T> resultList) {
        InMemoryEvaluator eval = new InMemoryEvaluator();
        eval.eval(resources, this, resultList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 31 * result + (this.includedFields == null ? 0 : this.includedFields.hashCode());
        result = 31 * result + (this.includedRelations == null ? 0 : this.includedRelations.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + Long.valueOf(this.offset).hashCode();
        result = 31 * result + (this.relatedSpecs == null ? 0 : this.relatedSpecs.hashCode());
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpec other = (QuerySpec)obj;
        return CompareUtils.isEquals(this.filters, other.filters) && CompareUtils.isEquals(this.includedFields, other.includedFields) && CompareUtils.isEquals(this.includedRelations, other.includedRelations) && CompareUtils.isEquals(this.limit, other.limit) && CompareUtils.isEquals(this.offset, other.offset) && CompareUtils.isEquals(this.relatedSpecs, other.relatedSpecs) && CompareUtils.isEquals(this.sort, other.sort);
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public List<FilterSpec> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterSpec> filters) {
        this.filters = filters;
    }

    public List<SortSpec> getSort() {
        return this.sort;
    }

    public void setSort(List<SortSpec> sort) {
        this.sort = sort;
    }

    public List<IncludeFieldSpec> getIncludedFields() {
        return this.includedFields;
    }

    public void setIncludedFields(List<IncludeFieldSpec> includedFields) {
        this.includedFields = includedFields;
    }

    public List<IncludeRelationSpec> getIncludedRelations() {
        return this.includedRelations;
    }

    public void setIncludedRelations(List<IncludeRelationSpec> includedRelations) {
        this.includedRelations = includedRelations;
    }

    public Map<Class<?>, QuerySpec> getRelatedSpecs() {
        return this.relatedSpecs;
    }

    public void setRelatedSpecs(Map<Class<?>, QuerySpec> relatedSpecs) {
        this.relatedSpecs = relatedSpecs;
    }

    public void addFilter(FilterSpec filterSpec) {
        this.filters.add(filterSpec);
    }

    public void addSort(SortSpec sortSpec) {
        this.sort.add(sortSpec);
    }

    public void includeField(List<String> attrPath) {
        this.includedFields.add(new IncludeFieldSpec(attrPath));
    }

    public void includeRelation(List<String> attrPath) {
        this.includedRelations.add(new IncludeRelationSpec(attrPath));
    }

    public QuerySpec getQuerySpec(Class<?> resourceClass) {
        if (resourceClass.equals(this.resourceClass)) {
            return this;
        }
        return this.relatedSpecs.get(resourceClass);
    }

    public QuerySpec getOrCreateQuerySpec(Class<?> resourceClass) {
        QuerySpec querySpec = this.getQuerySpec(resourceClass);
        if (querySpec == null) {
            querySpec = new QuerySpec(resourceClass);
            this.relatedSpecs.put(resourceClass, querySpec);
        }
        return querySpec;
    }

    public void putRelatedSpec(Class<?> relatedResourceClass, QuerySpec relatedSpec) {
        if (relatedResourceClass.equals(this.resourceClass)) {
            throw new IllegalArgumentException("cannot set related spec with root resourceClass");
        }
        this.relatedSpecs.put(relatedResourceClass, relatedSpec);
    }

    public QuerySpec duplicate() {
        QuerySpec copy = new QuerySpec(this.resourceClass);
        copy.limit = this.limit;
        copy.offset = this.offset;
        copy.includedFields.addAll(this.includedFields);
        copy.includedRelations.addAll(this.includedRelations);
        copy.sort.addAll(this.sort);
        copy.filters.addAll(this.filters);
        for (Map.Entry<Class<?>, QuerySpec> entry : this.relatedSpecs.entrySet()) {
            copy.relatedSpecs.put(entry.getKey(), entry.getValue().duplicate());
        }
        return copy;
    }

    public QuerySpec getQuerySpec(ResourceInformation resourceInformation) {
        return this.getQuerySpec(resourceInformation.getResourceClass());
    }

    public QuerySpec getOrCreateQuerySpec(ResourceInformation resourceInformation) {
        return this.getOrCreateQuerySpec(resourceInformation.getResourceClass());
    }

    public String toString() {
        return "QuerySpec{resourceClass=" + this.resourceClass + ", limit=" + this.limit + ", offset=" + this.offset + ", filters=" + this.filters + ", sort=" + this.sort + ", includedFields=" + this.includedFields + ", includedRelations=" + this.includedRelations + ", relatedSpecs=" + this.relatedSpecs + '}';
    }
}

