/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.registry;

import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.exception.RepositoryInstanceNotFoundException;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.registry.RepositoryEntryBuilder;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.RelationshipRepository;
import io.crnk.legacy.repository.ResourceRepository;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jodah.typetools.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRepositoryEntryBuilder
implements RepositoryEntryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectRepositoryEntryBuilder.class);
    private final JsonServiceLocator jsonServiceLocator;

    public DirectRepositoryEntryBuilder(JsonServiceLocator jsonServiceLocator) {
        this.jsonServiceLocator = jsonServiceLocator;
    }

    @Override
    public ResourceEntry buildResourceRepository(ResourceLookup lookup, Class<?> resourceClass) {
        Class<?> repoClass = this.getRepoClassType(lookup.getResourceRepositoryClasses(), resourceClass);
        if (repoClass == null) {
            return null;
        }
        DirectResponseResourceEntry directResourceEntry = new DirectResponseResourceEntry(new RepositoryInstanceBuilder<ResourceRepository>(this.jsonServiceLocator, repoClass));
        return directResourceEntry;
    }

    private Class<?> getRepoClassType(Set<Class<?>> repositoryClasses, Class<?> resourceClass) {
        for (Class<?> repoClass : repositoryClasses) {
            Class[] typeArgs;
            if (ResourceRepository.class.isAssignableFrom(repoClass) && (typeArgs = TypeResolver.resolveRawArguments(ResourceRepository.class, repoClass))[0] == resourceClass) {
                return repoClass;
            }
            if (!ResourceRepositoryV2.class.isAssignableFrom(repoClass) || (typeArgs = TypeResolver.resolveRawArguments(ResourceRepositoryV2.class, repoClass))[0] != resourceClass) continue;
            return repoClass;
        }
        return null;
    }

    @Override
    public List<ResponseRelationshipEntry> buildRelationshipRepositories(ResourceLookup lookup, Class<?> resourceClass) {
        Set<Class<?>> relationshipRepositoryClasses = lookup.getResourceRepositoryClasses();
        Set<Class<?>> relationshipRepositories = this.findRelationshipRepositories(resourceClass, relationshipRepositoryClasses);
        LinkedList<ResponseRelationshipEntry> relationshipEntries = new LinkedList<ResponseRelationshipEntry>();
        for (Class<?> relationshipRepositoryClass : relationshipRepositories) {
            Object relationshipRepository = this.jsonServiceLocator.getInstance(relationshipRepositoryClass);
            if (relationshipRepository == null) {
                throw new RepositoryInstanceNotFoundException(relationshipRepositoryClass.getCanonicalName());
            }
            LOGGER.debug("Assigned {} RelationshipRepository  to {} resource class", (Object)relationshipRepositoryClass.getCanonicalName(), (Object)resourceClass.getCanonicalName());
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(new RepositoryInstanceBuilder(this.jsonServiceLocator, relationshipRepositoryClass));
            relationshipEntries.add(relationshipEntry);
        }
        return relationshipEntries;
    }

    private Set<Class<?>> findRelationshipRepositories(Class resourceClass, Set<Class<?>> relationshipRepositoryClasses) {
        HashSet relationshipRepositories = new HashSet();
        for (Class<?> repoClass : relationshipRepositoryClasses) {
            Class[] typeArgs;
            if (RelationshipRepository.class.isAssignableFrom(repoClass) && (typeArgs = TypeResolver.resolveRawArguments(RelationshipRepository.class, repoClass))[0] == resourceClass) {
                relationshipRepositories.add(repoClass);
            }
            if (!RelationshipRepositoryV2.class.isAssignableFrom(repoClass) || (typeArgs = TypeResolver.resolveRawArguments(RelationshipRepositoryV2.class, repoClass))[0] != resourceClass) continue;
            relationshipRepositories.add(repoClass);
        }
        return relationshipRepositories;
    }
}

