/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.http;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.url.ServiceUrlProvider;

public class HttpRequestContextProvider
implements ServiceUrlProvider {
    private ThreadLocal<HttpRequestContext> threadLocal = new ThreadLocal();

    public HttpRequestContext getRequestContext() {
        return this.threadLocal.get();
    }

    @Override
    public String getUrl() {
        HttpRequestContext request = this.threadLocal.get();
        if (request == null) {
            throw new IllegalStateException("HttpRequestContext not available, make sure to call onRequestStarted in advance");
        }
        return request.getBaseUrl();
    }

    public void onRequestStarted(HttpRequestContext request) {
        this.threadLocal.set(request);
    }

    public void onRequestFinished() {
        this.threadLocal.remove();
    }
}

