/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import io.crnk.core.engine.internal.information.resource.AnnotatedClassBuilder;
import io.crnk.core.engine.internal.information.resource.AnnotatedFieldBuilder;
import io.crnk.core.engine.internal.information.resource.AnnotatedMethodBuilder;
import io.crnk.core.engine.internal.utils.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ResourceFieldNameTransformer {
    private final SerializationConfig serializationConfig;

    public ResourceFieldNameTransformer() {
        this(null);
    }

    public ResourceFieldNameTransformer(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
    }

    private static AnnotationMap buildAnnotationMap(Annotation[] declaredAnnotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        for (Annotation annotation : declaredAnnotations) {
            annotationMap.add(annotation);
        }
        return annotationMap;
    }

    public String getName(Field field) {
        String name = field.getName();
        if (field.isAnnotationPresent(JsonProperty.class) && !"".equals(field.getAnnotation(JsonProperty.class).value())) {
            name = field.getAnnotation(JsonProperty.class).value();
        } else if (this.serializationConfig != null && this.serializationConfig.getPropertyNamingStrategy() != null) {
            AnnotationMap annotationMap = ResourceFieldNameTransformer.buildAnnotationMap(field.getDeclaredAnnotations());
            AnnotatedClass annotatedClass = AnnotatedClassBuilder.build(field.getDeclaringClass(), this.serializationConfig);
            AnnotatedField annotatedField = AnnotatedFieldBuilder.build(annotatedClass, field, annotationMap);
            name = this.serializationConfig.getPropertyNamingStrategy().nameForField((MapperConfig)this.serializationConfig, annotatedField, name);
        }
        return name;
    }

    public String getName(Method method) {
        String name = ClassUtils.getGetterFieldName(method);
        if (method.isAnnotationPresent(JsonProperty.class) && !"".equals(method.getAnnotation(JsonProperty.class).value())) {
            name = method.getAnnotation(JsonProperty.class).value();
        } else if (this.serializationConfig != null && this.serializationConfig.getPropertyNamingStrategy() != null) {
            Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
            AnnotationMap annotationMap = ResourceFieldNameTransformer.buildAnnotationMap(declaredAnnotations);
            int paramsLength = method.getParameterAnnotations().length;
            AnnotationMap[] paramAnnotations = new AnnotationMap[paramsLength];
            for (int i = 0; i < paramsLength; ++i) {
                AnnotationMap parameterAnnotationMap;
                paramAnnotations[i] = parameterAnnotationMap = ResourceFieldNameTransformer.buildAnnotationMap(method.getParameterAnnotations()[i]);
            }
            AnnotatedClass annotatedClass = AnnotatedClassBuilder.build(method.getDeclaringClass(), this.serializationConfig);
            AnnotatedMethod annotatedField = AnnotatedMethodBuilder.build(annotatedClass, method, annotationMap, paramAnnotations);
            name = this.serializationConfig.getPropertyNamingStrategy().nameForGetterMethod((MapperConfig)this.serializationConfig, annotatedField, name);
        }
        return name;
    }
}

