/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.IncludeBehavior;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupUtil;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.annotations.JsonApiLookupIncludeAutomatically;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.QueryParamsAdapter;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeLookupSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeLookupSetter.class);
    private final ResourceRegistry resourceRegistry;
    private final LookupIncludeBehavior globalLookupIncludeBehavior;
    private ResourceMapper resourceMapper;
    private IncludeLookupUtil util;
    private boolean allowPagination = false;

    public IncludeLookupSetter(ResourceRegistry resourceRegistry, ResourceMapper resourceMapper, PropertiesProvider propertiesProvider) {
        this.resourceMapper = resourceMapper;
        this.resourceRegistry = resourceRegistry;
        this.globalLookupIncludeBehavior = IncludeLookupUtil.getDefaultLookupIncludeBehavior(propertiesProvider);
        IncludeBehavior includeBehavior = IncludeLookupUtil.getIncludeBehavior(propertiesProvider);
        this.util = new IncludeLookupUtil(resourceRegistry, includeBehavior);
        this.allowPagination = propertiesProvider != null && Boolean.parseBoolean(propertiesProvider.getProperty("crnk.config.include.paging.enabled"));
    }

    public void setIncludedElements(Document document, Object entity, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRelations) {
        QueryAdapter inclusionQueryAdapter = queryAdapter;
        if (!this.allowPagination && !(queryAdapter instanceof QueryParamsAdapter) && queryAdapter != null) {
            inclusionQueryAdapter = queryAdapter.duplicate();
            inclusionQueryAdapter.setOffset(0L);
            inclusionQueryAdapter.setLimit(null);
        }
        List entityList = DocumentMapperUtil.toList(entity);
        List<Resource> dataList = DocumentMapperUtil.toList(document.getData().get());
        HashMap<ResourceIdentifier, Resource> dataMap = new HashMap<ResourceIdentifier, Resource>();
        HashMap<ResourceIdentifier, Object> entityMap = new HashMap<ResourceIdentifier, Object>();
        for (int i = 0; i < dataList.size(); ++i) {
            Resource dataElement = (Resource)dataList.get(i);
            ResourceIdentifier id = dataElement.toIdentifier();
            entityMap.put(id, entityList.get(i));
            dataMap.put(id, dataElement);
        }
        HashMap<ResourceIdentifier, Resource> resourceMap = new HashMap<ResourceIdentifier, Resource>();
        resourceMap.putAll(dataMap);
        HashSet<ResourceIdentifier> inclusions = new HashSet<ResourceIdentifier>();
        PopulatedCache populatedCache = new PopulatedCache();
        ArrayList<ResourceField> stack = new ArrayList<ResourceField>();
        this.populate(dataList, inclusions, resourceMap, entityMap, stack, inclusionQueryAdapter, parameterProvider, additionalEagerLoadedRelations, populatedCache);
        inclusions.removeAll(dataMap.keySet());
        ArrayList<Resource> included = new ArrayList<Resource>();
        for (ResourceIdentifier inclusionId : inclusions) {
            Resource includedResource = (Resource)resourceMap.get(inclusionId);
            PreconditionUtil.assertNotNull("resource not found", includedResource);
            included.add(includedResource);
        }
        Collections.sort(included);
        LOGGER.debug("Extracted included resources {}", (Object)included.toString());
        document.setIncluded(included);
    }

    private void populate(Collection<Resource> resourceList, Set<ResourceIdentifier> inclusions, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, List<ResourceField> fieldPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRootRelations, PopulatedCache populatedCache) {
        if (resourceList.isEmpty()) {
            return;
        }
        this.checkNoRecursion(fieldPath);
        Set<ResourceField> relationshipFields = this.util.getRelationshipFields(resourceList);
        for (ResourceField resourceField : relationshipFields) {
            fieldPath.add(resourceField);
            this.populateField(resourceField, queryAdapter, fieldPath, populatedCache, resourceList, additionalEagerLoadedRootRelations, parameterProvider, resourceMap, entityMap, inclusions);
            fieldPath.remove(fieldPath.size() - 1);
        }
    }

    private void populateField(ResourceField resourceField, QueryAdapter queryAdapter, List<ResourceField> fieldPath, PopulatedCache populatedCache, Collection<Resource> resourceList, Set<String> additionalEagerLoadedRootRelations, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, Set<ResourceIdentifier> inclusions) {
        Collection<Resource> unpopulatedResourceList;
        boolean includeRelationshipData;
        ResourceInformation resourceInformation = resourceField.getParentResourceInformation();
        boolean includeRequested = this.util.isInclusionRequested(queryAdapter, fieldPath);
        boolean includeResources = includeRequested || resourceField.getIncludeByDefault();
        boolean bl = includeRelationshipData = !resourceField.isLazy() || includeResources || additionalEagerLoadedRootRelations.contains(resourceField.getJsonName());
        if (includeRelationshipData && !(unpopulatedResourceList = populatedCache.filterProcessed(resourceList, resourceField)).isEmpty()) {
            Set<Resource> populatedResources;
            List<Resource> resourcesByType = this.util.filterByType(unpopulatedResourceList, resourceInformation);
            List<Resource> resourcesWithField = this.util.filterByLoadedRelationship(resourcesByType, resourceField);
            LookupIncludeBehavior fieldLookupIncludeBehavior = resourceField.getLookupIncludeAutomatically();
            if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_ALWAYS || this.globalLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_ALWAYS) {
                populatedResources = this.lookupRelationshipField(resourcesWithField, resourceField, queryAdapter, parameterProvider, resourceMap, entityMap);
            } else if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL || this.globalLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL) {
                Set<Resource> extractedResources = this.extractRelationshipField(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, true);
                List<Resource> resourcesForLookup = this.util.findResourcesWithoutRelationshipData(resourcesWithField, resourceField);
                Set<Resource> lookedupResources = this.lookupRelationshipField(resourcesForLookup, resourceField, queryAdapter, parameterProvider, resourceMap, entityMap);
                populatedResources = this.util.union(lookedupResources, extractedResources);
            } else {
                populatedResources = this.extractRelationshipField(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, false);
                if (!Iterable.class.isAssignableFrom(resourceField.getType())) {
                    Nullable<Object> emptyData = Nullable.nullValue();
                    for (Resource resourceWithField : resourcesWithField) {
                        Relationship relationship = resourceWithField.getRelationships().get(resourceField.getJsonName());
                        if (relationship.getData().isPresent()) continue;
                        relationship.setData(emptyData);
                    }
                }
            }
            if (includeResources && !populatedResources.isEmpty()) {
                inclusions.addAll(this.util.toIds(populatedResources));
                Set<String> additionalEagerLoadedNestedRelations = Collections.emptySet();
                this.populate(populatedResources, inclusions, resourceMap, entityMap, fieldPath, queryAdapter, parameterProvider, additionalEagerLoadedNestedRelations, populatedCache);
            }
        }
    }

    private void checkNoRecursion(List<ResourceField> fieldPath) {
        int index = fieldPath.size();
        if (index >= 42) {
            throw new IllegalStateException("42 nested inclusions reached, aborting");
        }
    }

    private Set<Resource> extractRelationshipField(List<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, boolean lookUp) {
        HashSet<Resource> loadedEntities = new HashSet<Resource>();
        for (Resource sourceResource : sourceResources) {
            ResourceIdentifier id = sourceResource.toIdentifier();
            Object source = entityMap.get(id);
            if (source == null || source instanceof Resource) continue;
            Object targetEntity = relationshipField.getAccessor().getValue(source);
            if (!lookUp && Iterable.class.isAssignableFrom(relationshipField.getType()) && targetEntity == null) {
                throw new InternalServerErrorException(id + " relationship field collection '" + relationshipField.getJsonName() + "' can not be null. Either set the relationship as an empty " + Iterable.class.getCanonicalName() + " or add annotation @" + JsonApiLookupIncludeAutomatically.class.getCanonicalName());
            }
            if (targetEntity == null) continue;
            List<Resource> targetIds = this.setupRelation(sourceResource, relationshipField, targetEntity, queryAdapter, resourceMap, entityMap);
            loadedEntities.addAll(targetIds);
        }
        return loadedEntities;
    }

    private Set<Resource> lookupRelationshipField(Collection<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap) {
        if (sourceResources.isEmpty()) {
            return Collections.emptySet();
        }
        ResourceInformation resourceInformation = relationshipField.getParentResourceInformation();
        RegistryEntry registyEntry = this.resourceRegistry.getEntry(resourceInformation.getResourceType());
        List<Serializable> resourceIds = this.getIds(sourceResources, resourceInformation);
        boolean isMany = Iterable.class.isAssignableFrom(relationshipField.getType());
        HashSet<Resource> loadedTargets = new HashSet<Resource>();
        RelationshipRepositoryAdapter relationshipRepository = registyEntry.getRelationshipRepositoryForType(relationshipField.getOppositeResourceType(), parameterProvider);
        if (relationshipRepository != null) {
            Map<Serializable, JsonApiResponse> responseMap = isMany ? relationshipRepository.findBulkManyTargets(resourceIds, relationshipField, queryAdapter) : relationshipRepository.findBulkOneTargets(resourceIds, relationshipField, queryAdapter);
            for (Resource sourceResource : sourceResources) {
                Serializable sourceId = resourceInformation.parseIdString(sourceResource.getId());
                JsonApiResponse targetResponse = responseMap.get(sourceId);
                if (targetResponse != null && targetResponse.getEntity() != null) {
                    Object targetEntity = targetResponse.getEntity();
                    List<Resource> targets = this.setupRelation(sourceResource, relationshipField, targetEntity, queryAdapter, resourceMap, entityMap);
                    loadedTargets.addAll(targets);
                    continue;
                }
                Nullable<Object> emptyData = Nullable.of(Iterable.class.isAssignableFrom(relationshipField.getType()) ? Collections.emptyList() : null);
                Relationship relationship = sourceResource.getRelationships().get(relationshipField.getJsonName());
                relationship.setData(emptyData);
            }
        }
        return loadedTargets;
    }

    private List<Resource> setupRelation(Resource sourceResource, ResourceField relationshipField, Object targetEntity, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap) {
        String relationshipName = relationshipField.getJsonName();
        Map<String, Relationship> relationships = sourceResource.getRelationships();
        Relationship relationship = relationships.get(relationshipName);
        if (targetEntity instanceof Iterable) {
            ArrayList<Resource> targets = new ArrayList<Resource>();
            for (Object targetElement : (Iterable)targetEntity) {
                Resource targetResource = this.mergeResource(targetElement, queryAdapter, resourceMap, entityMap);
                targets.add(targetResource);
            }
            relationship.setData(Nullable.of(this.util.toIds(targets)));
            return targets;
        }
        Resource targetResource = this.mergeResource(targetEntity, queryAdapter, resourceMap, entityMap);
        relationship.setData(Nullable.of(targetResource.toIdentifier()));
        return Collections.singletonList(targetResource);
    }

    private Resource mergeResource(Object targetEntity, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap) {
        Resource targetResource = this.resourceMapper.toData(targetEntity, queryAdapter);
        ResourceIdentifier targetId = targetResource.toIdentifier();
        if (!resourceMap.containsKey(targetId)) {
            resourceMap.put(targetId, targetResource);
        } else {
            targetResource = resourceMap.get(targetId);
        }
        if (!(targetEntity instanceof Resource)) {
            entityMap.put(targetId, targetEntity);
        }
        return targetResource;
    }

    private List<Serializable> getIds(Collection<Resource> resources, ResourceInformation resourceInformation) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (Resource resource : resources) {
            Serializable id = resourceInformation.parseIdString(resource.getId());
            ids.add(id);
        }
        return ids;
    }

    class PopulatedCache {
        private HashSet<String> processed = new HashSet();

        PopulatedCache() {
        }

        public void markProcessed(Resource resource, ResourceField field) {
            String key = this.getKey(resource, field);
            this.processed.add(key);
        }

        public Collection<Resource> filterProcessed(Collection<Resource> resources, ResourceField field) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            for (Resource resource : resources) {
                if (this.wasProcessed(resource, field)) continue;
                result.add(resource);
                this.markProcessed(resource, field);
            }
            return result;
        }

        public boolean wasProcessed(Resource resource, ResourceField field) {
            String key = this.getKey(resource, field);
            return this.processed.contains(key);
        }

        private String getKey(Resource resource, ResourceField field) {
            return IncludeLookupSetter.this.resourceRegistry.getBaseResourceInformation(resource.getType()).getResourceType() + "@" + resource.getId() + "@" + field.getUnderlyingName();
        }
    }
}

