/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.internal.exception.CrnkExceptionMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperType;
import io.crnk.core.engine.internal.utils.TypeUtils;
import io.crnk.legacy.internal.DefaultExceptionMapperLookup;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public final class ExceptionMapperRegistryBuilder {
    private final Set<ExceptionMapperType> exceptionMappers = new HashSet<ExceptionMapperType>();

    public ExceptionMapperRegistry build(String resourceSearchPackage) {
        return this.build(new DefaultExceptionMapperLookup(resourceSearchPackage));
    }

    public ExceptionMapperRegistry build(ExceptionMapperLookup exceptionMapperLookup) {
        this.addDefaultMappers();
        for (JsonApiExceptionMapper exceptionMapper : exceptionMapperLookup.getExceptionMappers()) {
            this.registerExceptionMapper(exceptionMapper);
        }
        return new ExceptionMapperRegistry(this.exceptionMappers);
    }

    private void addDefaultMappers() {
        this.registerExceptionMapper(new CrnkExceptionMapper());
    }

    private void registerExceptionMapper(JsonApiExceptionMapper<? extends Throwable> exceptionMapper) {
        Class<? extends Throwable> exceptionClass = this.getGenericType(exceptionMapper.getClass());
        this.exceptionMappers.add(new ExceptionMapperType(exceptionClass, exceptionMapper));
    }

    private Class<? extends Throwable> getGenericType(Class<? extends JsonApiExceptionMapper> mapper) {
        Type[] types = mapper.getGenericInterfaces();
        if (null == types || 0 == types.length) {
            types = new Type[]{mapper.getGenericSuperclass()};
        }
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !TypeUtils.isAssignable(((ParameterizedType)type).getRawType(), JsonApiExceptionMapper.class) && !TypeUtils.isAssignable(((ParameterizedType)type).getRawType(), ExceptionMapper.class)) continue;
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }
}

