/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information;

import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryAction;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.repository.RelationshipRepositoryInformationImpl;
import io.crnk.core.engine.internal.information.repository.ResourceRepositoryInformationImpl;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultInformationBuilder
implements InformationBuilder {
    private final TypeParser typeParser;

    public InformationBuilder.RelationshipRepository createRelationshipRepository(String targetResourceType) {
        return this.createRelationshipRepository(null, targetResourceType);
    }

    @Override
    public InformationBuilder.RelationshipRepository createRelationshipRepository(String sourceResourceType, String targetResourceType) {
        DefaultRelationshipRepository repository = new DefaultRelationshipRepository();
        repository.sourceResourceType = sourceResourceType;
        repository.targetResourceType = targetResourceType;
        return repository;
    }

    public InformationBuilder.ResourceRepository createResourceRepository() {
        return this.createResourceRepository(null, null);
    }

    @Override
    public InformationBuilder.ResourceRepository createResourceRepository(Class<?> resourceClass, String resourceType) {
        DefaultResource resource = new DefaultResource();
        resource.resourceClass(resourceClass);
        resource.resourceType(resourceType);
        DefaultResourceRepository repository = new DefaultResourceRepository();
        repository.resource = resource;
        return repository;
    }

    @Override
    public InformationBuilder.Resource createResource(Class<?> resourceClass, String resourceType) {
        DefaultResource resource = new DefaultResource();
        resource.resourceClass(resourceClass);
        resource.resourceType(resourceType);
        return resource;
    }

    public DefaultInformationBuilder(TypeParser typeParser) {
        this.typeParser = typeParser;
    }

    public class DefaultField
    implements InformationBuilder.Field {
        private String jsonName;
        private String underlyingName;
        private Class<?> type;
        private Type genericType;
        private boolean lazy = true;
        private String oppositeResourceType = null;
        private LookupIncludeBehavior lookupIncludeBehavior = LookupIncludeBehavior.NONE;
        private boolean includeByDefault = false;
        private ResourceFieldType fieldType = ResourceFieldType.ATTRIBUTE;
        private String oppositeName;
        private ResourceFieldAccessor accessor;
        private ResourceFieldAccess access = new ResourceFieldAccess(true, true, true, true);

        @Override
        public ResourceField build() {
            return new ResourceFieldImpl(this.jsonName, this.underlyingName, this.fieldType, this.type, this.genericType, this.oppositeResourceType, this.oppositeName, this.lazy, this.includeByDefault, this.lookupIncludeBehavior, this.access);
        }

        @Override
        public void jsonName(String jsonName) {
            this.jsonName = jsonName;
        }

        @Override
        public void underlyingName(String underlyingName) {
            this.underlyingName = underlyingName;
        }

        @Override
        public void type(Class<?> type) {
            this.type = type;
        }

        @Override
        public void genericType(Type genericType) {
            this.genericType = genericType;
        }

        @Override
        public void lazy(boolean lazy) {
            this.lazy = lazy;
        }

        @Override
        public void oppositeResourceType(String oppositeResourceType) {
            this.oppositeResourceType = oppositeResourceType;
        }

        @Override
        public void lookupIncludeBehavior(LookupIncludeBehavior lookupIncludeBehavior) {
            this.lookupIncludeBehavior = lookupIncludeBehavior;
        }

        @Override
        public void includeByDefault(boolean includeByDefault) {
            this.includeByDefault = includeByDefault;
        }

        @Override
        public void fieldType(ResourceFieldType fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public void setOppositeName(String oppositeName) {
            this.oppositeName = oppositeName;
        }

        @Override
        public void setAccessor(ResourceFieldAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public void setAccess(ResourceFieldAccess access) {
            this.access = access;
        }
    }

    public class DefaultResource
    implements InformationBuilder.Resource {
        private List<DefaultField> fields = new ArrayList<DefaultField>();
        private Class<?> resourceClass;
        private String resourceType;
        private String superResourceType;

        @Override
        public DefaultField addField(String name, ResourceFieldType type, Class<?> clazz) {
            DefaultField field = new DefaultField();
            field.jsonName(name);
            field.underlyingName(name);
            field.type(clazz);
            field.genericType(clazz);
            field.fieldType(type);
            this.fields.add(field);
            return field;
        }

        @Override
        public void resourceClass(Class<?> resourceClass) {
            this.resourceClass = resourceClass;
        }

        @Override
        public void resourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public void superResourceType(String superResourceType) {
            this.superResourceType = superResourceType;
        }

        @Override
        public ResourceInformation build() {
            ArrayList<ResourceField> fieldImpls = new ArrayList<ResourceField>();
            for (DefaultField field : this.fields) {
                fieldImpls.add(field.build());
            }
            return new ResourceInformation(DefaultInformationBuilder.this.typeParser, this.resourceClass, this.resourceType, this.superResourceType, fieldImpls);
        }
    }

    public class DefaultResourceRepository
    implements InformationBuilder.ResourceRepository {
        private DefaultResource resource;
        private Map<String, RepositoryAction> actions = new HashMap<String, RepositoryAction>();

        public DefaultResource resource() {
            return this.resource;
        }

        @Override
        public ResourceRepositoryInformation build() {
            ResourceInformation resourceInformation = this.resource.build();
            return new ResourceRepositoryInformationImpl(resourceInformation.getResourceType(), resourceInformation, this.actions);
        }
    }

    public class DefaultRelationshipRepository
    implements InformationBuilder.RelationshipRepository {
        private String sourceResourceType;
        private String targetResourceType;

        @Override
        public RelationshipRepositoryInformation build() {
            return new RelationshipRepositoryInformationImpl(null, this.sourceResourceType, this.targetResourceType);
        }
    }
}

