/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.resource.RawResourceFieldAccessor;
import io.crnk.core.engine.internal.information.resource.ReflectionFieldAccessor;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ResourceFieldImpl
implements ResourceField {
    private final String jsonName;
    private final String underlyingName;
    private final Class<?> type;
    private final Type genericType;
    private final boolean lazy;
    private final String oppositeResourceType;
    private final LookupIncludeBehavior lookupIncludeBehavior;
    private final boolean includeByDefault;
    private final ResourceFieldType resourceFieldType;
    private final String oppositeName;
    private ResourceInformation parentResourceInformation;
    private ResourceFieldAccessor accessor;
    private final ResourceFieldAccess access;

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType) {
        this(jsonName, underlyingName, resourceFieldType, type, genericType, oppositeResourceType, null, true, false, LookupIncludeBehavior.NONE, new ResourceFieldAccess(true, true, true, true));
    }

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType, String oppositeName, boolean lazy, boolean includeByDefault, LookupIncludeBehavior lookupIncludeBehavior, ResourceFieldAccess access) {
        this.jsonName = jsonName;
        this.underlyingName = underlyingName;
        this.resourceFieldType = resourceFieldType;
        this.includeByDefault = includeByDefault;
        this.type = type;
        this.genericType = genericType;
        this.lazy = lazy;
        this.lookupIncludeBehavior = lookupIncludeBehavior;
        this.oppositeName = oppositeName;
        this.oppositeResourceType = oppositeResourceType;
        this.access = access;
    }

    @Override
    public ResourceFieldType getResourceFieldType() {
        return this.resourceFieldType;
    }

    @Override
    public LookupIncludeBehavior getLookupIncludeAutomatically() {
        return this.lookupIncludeBehavior;
    }

    @Override
    public String getOppositeName() {
        return this.oppositeName;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public String getOppositeResourceType() {
        PreconditionUtil.assertEquals("not an association", (Object)ResourceFieldType.RELATIONSHIP, (Object)this.resourceFieldType);
        if (this.getElementType() != Object.class) {
            PreconditionUtil.assertNotNull("resourceType must not be null", this.oppositeResourceType);
        }
        return this.oppositeResourceType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean getIncludeByDefault() {
        return this.includeByDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldImpl that = (ResourceFieldImpl)o;
        return Objects.equals(this.jsonName, that.jsonName);
    }

    public int hashCode() {
        return Objects.hash(this.jsonName);
    }

    @Override
    public Class<?> getElementType() {
        if (Iterable.class.isAssignableFrom(this.type) && this.getGenericType() instanceof Class) {
            return Object.class;
        }
        if (Iterable.class.isAssignableFrom(this.type)) {
            return (Class)((ParameterizedType)this.getGenericType()).getActualTypeArguments()[0];
        }
        return this.type;
    }

    @Override
    public ResourceInformation getParentResourceInformation() {
        return this.parentResourceInformation;
    }

    @Override
    public ResourceFieldAccessor getAccessor() {
        PreconditionUtil.assertNotNull("field not properly initialized", this.accessor);
        return this.accessor;
    }

    public void setAccessor(ResourceFieldAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void setResourceInformation(ResourceInformation resourceInformation) {
        if (this.accessor == null && resourceInformation.getResourceClass() == Resource.class) {
            this.accessor = new RawResourceFieldAccessor(this.underlyingName, this.resourceFieldType, this.type);
        } else if (this.accessor == null) {
            this.accessor = new ReflectionFieldAccessor(resourceInformation.getResourceClass(), this.underlyingName, this.type);
        }
        this.parentResourceInformation = resourceInformation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[jsonName=").append(this.jsonName);
        if (this.parentResourceInformation != null && this.parentResourceInformation.getResourceType() != null) {
            sb.append(",resourceType=").append(this.parentResourceInformation);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.getType());
    }

    @Override
    public ResourceFieldAccess getAccess() {
        return this.access;
    }
}

