/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Optional;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceRegistryImpl
implements ResourceRegistry {
    private final ServiceUrlProvider serviceUrlProvider;
    private ModuleRegistry moduleRegistry;
    private ConcurrentHashMap<String, ResourceInformation> baseTypeCache = new ConcurrentHashMap();
    private ResourceRegistryPart rootPart;

    public ResourceRegistryImpl(ResourceRegistryPart rootPart, ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrlProvider) {
        this.rootPart = rootPart;
        this.moduleRegistry = moduleRegistry;
        this.serviceUrlProvider = serviceUrlProvider;
        this.moduleRegistry.setResourceRegistry(this);
    }

    @Override
    public RegistryEntry addEntry(Class<?> resource, RegistryEntry registryEntry) {
        return this.addEntry(registryEntry);
    }

    protected RegistryEntry findEntry(Class<?> clazz, boolean allowNull) {
        Optional<Class<?>> resourceClazz = this.getResourceClass(clazz);
        if (allowNull && !resourceClazz.isPresent()) {
            return null;
        }
        if (!resourceClazz.isPresent()) {
            throw new RepositoryNotFoundException(clazz.getCanonicalName());
        }
        return this.rootPart.getEntry(resourceClazz.get());
    }

    @Override
    public RegistryEntry findEntry(Class<?> clazz) {
        return this.findEntry(clazz, false);
    }

    public Optional<Class<?>> getResourceClass(Class<?> resourceClass) {
        for (Class<?> currentClass = resourceClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            RegistryEntry entry = this.rootPart.getEntry(currentClass);
            if (entry == null) continue;
            return Optional.of(currentClass);
        }
        return Optional.empty();
    }

    @Override
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    @Override
    @Deprecated
    public RegistryEntry getEntryForClass(Class<?> resourceClass) {
        return this.getEntry(resourceClass);
    }

    public Optional<Class<?>> getResourceClass(Object resource) {
        return this.getResourceClass(resource.getClass());
    }

    @Override
    public String getResourceUrl(ResourceInformation resourceInformation) {
        String url = UrlUtils.removeTrailingSlash(this.serviceUrlProvider.getUrl());
        return url + "/" + resourceInformation.getResourceType();
    }

    @Override
    public ResourceInformation getBaseResourceInformation(String resourceType) {
        ResourceInformation baseInformation = this.baseTypeCache.get(resourceType);
        if (baseInformation != null) {
            return baseInformation;
        }
        RegistryEntry entry = this.getEntry(resourceType);
        baseInformation = entry.getResourceInformation();
        while (baseInformation.getSuperResourceType() != null) {
            entry = this.getEntry(baseInformation.getSuperResourceType());
            baseInformation = entry.getResourceInformation();
        }
        this.baseTypeCache.put(resourceType, baseInformation);
        return baseInformation;
    }

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        return this.rootPart.addEntry(entry);
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.rootPart.hasEntry(clazz);
    }

    @Override
    public boolean hasEntry(String resourceType) {
        return this.rootPart.hasEntry(resourceType);
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.rootPart.getEntry(resourceType);
    }

    @Override
    public Collection<RegistryEntry> getResources() {
        return this.rootPart.getResources();
    }

    @Override
    public RegistryEntry getEntry(Class<?> clazz) {
        return this.rootPart.getEntry(clazz);
    }
}

