/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.utils.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    public static final String PREFIX_GETTER_IS = "is";
    public static final String PREFIX_GETTER_GET = "get";
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    private ClassUtils() {
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return wrapperPrimitiveMap.containsKey(type);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        boolean autoboxing = true;
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
            return false;
        }
        if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
            return false;
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?>[] primitivesToWrappers(Class ... classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.primitiveToWrapper(classes[i]);
        }
        return convertedClasses;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Class<?>[] wrappersToPrimitives(Class ... classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.wrapperToPrimitive(classes[i]);
        }
        return convertedClasses;
    }

    @Deprecated
    public static Class<?> getResourceClass(Type genericType, Class baseClass) {
        if (Iterable.class.isAssignableFrom(baseClass)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)genericType;
                Type[] fieldArgTypes = aType.getActualTypeArguments();
                if (fieldArgTypes.length == 1 && fieldArgTypes[0] instanceof Class) {
                    return (Class)fieldArgTypes[0];
                }
                throw new IllegalArgumentException("Wrong type: " + aType);
            }
            throw new IllegalArgumentException("The relationship must be parametrized (cannot be wildcard or array): " + genericType);
        }
        return baseClass;
    }

    public static boolean existsClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<Field> getClassFields(Class<?> beanClass) {
        HashMap<String, Field> resultMap = new HashMap<String, Field>();
        LinkedList<Field> results = new LinkedList<Field>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                Field v;
                if (field.isSynthetic() || (v = (Field)resultMap.get(field.getName())) != null) continue;
                resultMap.put(field.getName(), field);
                results.add(field);
            }
        }
        return results;
    }

    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> beanClass, Class<T> annotationClass) {
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!currentClass.isAnnotationPresent(annotationClass)) continue;
            return Optional.of(currentClass.getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    public static Field findClassField(Class<?> beanClass, String fieldName) {
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (field.isSynthetic() || !field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static Method findGetter(Class<?> beanClass, String fieldName) {
        for (Method method : beanClass.getMethods()) {
            String methodGetterName;
            if (!ClassUtils.isGetter(method) || !fieldName.equals(methodGetterName = ClassUtils.getGetterFieldName(method))) continue;
            return method;
        }
        return null;
    }

    public static String getGetterFieldName(Method getter) {
        int getterPrefixLength = ClassUtils.getPropertyGetterPrefixLength(getter);
        if (getterPrefixLength == 0) {
            return null;
        }
        return StringUtils.decapitalize(getter.getName().substring(getterPrefixLength));
    }

    private static boolean isValidBeanGetter(Method getter) {
        int parameterCount = getter.getParameterTypes().length;
        Class<?> returnType = getter.getReturnType();
        return returnType != null && parameterCount == 0;
    }

    private static int getPropertyGetterPrefixLength(Method getter) {
        if (!ClassUtils.isValidBeanGetter(getter)) {
            return 0;
        }
        String name = getter.getName();
        boolean isBooleanReturnType = ClassUtils.isBoolean(getter.getReturnType());
        int prefixLength = 0;
        if (isBooleanReturnType && name.startsWith(PREFIX_GETTER_IS)) {
            prefixLength = 2;
        }
        if (name.startsWith(PREFIX_GETTER_GET)) {
            prefixLength = 3;
        }
        if (prefixLength == name.length()) {
            prefixLength = 0;
        }
        return prefixLength;
    }

    private static boolean isBoolean(Class<?> returnType) {
        return Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType);
    }

    public static Method findSetter(Class<?> beanClass, String fieldName, Class<?> fieldType) {
        String upperCaseName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return beanClass.getMethod("set" + upperCaseName, fieldType);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    public static List<Method> getClassGetters(Class<?> beanClass) {
        HashMap<String, Method> resultMap = new HashMap<String, Method>();
        LinkedList<Method> results = new LinkedList<Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            ClassUtils.getDeclaredClassGetters(currentClass, resultMap, results);
        }
        return results;
    }

    private static void getDeclaredClassGetters(Class<?> currentClass, Map<String, Method> resultMap, LinkedList<Method> results) {
        for (Method method : currentClass.getDeclaredMethods()) {
            Method v;
            if (method.isSynthetic() || !ClassUtils.isGetter(method) || (v = resultMap.get(method.getName())) != null) continue;
            resultMap.put(method.getName(), method);
            results.add(method);
        }
    }

    public static List<Method> getClassSetters(Class<?> beanClass) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                Method v;
                if (method.isSynthetic() || !ClassUtils.isSetter(method) || (v = (Method)result.get(method.getName())) != null) continue;
                result.put(method.getName(), method);
            }
        }
        return new LinkedList<Method>(result.values());
    }

    public static Method findMethodWith(Class<?> searchClass, Class<? extends Annotation> annotationClass) {
        while (searchClass != null && searchClass != Object.class) {
            for (Method method : searchClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                return method;
            }
            searchClass = searchClass.getSuperclass();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResourceException(String.format("couldn't create a new instance of %s", clazz));
        }
    }

    private static boolean isGetter(Method method) {
        return ClassUtils.isBooleanGetter(method) || ClassUtils.isNonBooleanGetter(method);
    }

    public static boolean isBooleanGetter(Method method) {
        boolean startsWithValidPrefix;
        boolean bl = startsWithValidPrefix = ClassUtils.getPropertyGetterPrefixLength(method) > 0;
        if (!startsWithValidPrefix || method.getParameterTypes().length != 0) {
            return false;
        }
        return Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType());
    }

    private static boolean isNonBooleanGetter(Method method) {
        if (!method.getName().startsWith(PREFIX_GETTER_GET)) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    private static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getName().length() < 4) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getRawType(((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public static boolean isPrimitiveType(Class<?> type) {
        boolean isInt = type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE;
        boolean isDecimal = type == Short.TYPE || type == Double.TYPE;
        return type == Boolean.TYPE || isInt || isDecimal;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
    }
}

