/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformationBuilder;
import io.crnk.core.engine.information.repository.RepositoryInformationBuilderContext;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationBuilder;
import io.crnk.core.engine.information.resource.ResourceInformationBuilderContext;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistryBuilder;
import io.crnk.core.engine.internal.registry.DefaultRegistryEntryBuilder;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.Decorator;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.InitializingModule;
import io.crnk.core.module.Module;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.MultiResourceLookup;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.internal.DefaultRepositoryInformationBuilderContext;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.decorate.RelationshipRepositoryDecorator;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.decorate.ResourceRepositoryDecorator;
import io.crnk.core.utils.Optional;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import io.crnk.legacy.registry.DefaultResourceInformationBuilderContext;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleRegistry {
    private TypeParser typeParser = new TypeParser();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private List<Module> modules = new ArrayList<Module>();
    private SimpleModule aggregatedModule = new SimpleModule(null);
    private volatile boolean initialized;
    private ServiceDiscovery serviceDiscovery;
    private boolean isServer = true;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private RequestDispatcher requestDispatcher;
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();

    public ModuleRegistry() {
        this(true);
    }

    public ModuleRegistry(boolean isServer) {
        this.isServer = isServer;
    }

    public void addModule(Module module) {
        module.setupModule(new ModuleContextImpl());
        this.modules.add(module);
    }

    public ResourceRegistry getResourceRegistry() {
        if (this.resourceRegistry == null) {
            throw new IllegalStateException("resourceRegistry not yet available");
        }
        return this.resourceRegistry;
    }

    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public void setRequestDispatcher(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return this.aggregatedModule.getJacksonModules();
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized, cannot be changed anymore");
        }
    }

    public ResourceInformationBuilder getResourceInformationBuilder() {
        CombinedResourceInformationBuilder resourceInformationBuilder = new CombinedResourceInformationBuilder(this.aggregatedModule.getResourceInformationBuilders());
        DefaultResourceInformationBuilderContext context = new DefaultResourceInformationBuilderContext(resourceInformationBuilder, this.typeParser);
        resourceInformationBuilder.init(context);
        return resourceInformationBuilder;
    }

    public RepositoryInformationBuilder getRepositoryInformationBuilder() {
        return new CombinedRepositoryInformationBuilder(this.aggregatedModule.getRepositoryInformationBuilders());
    }

    public ResourceLookup getResourceLookup() {
        return new MultiResourceLookup(this.aggregatedModule.getResourceLookups());
    }

    public List<HttpRequestProcessor> getHttpRequestProcessors() {
        return this.aggregatedModule.getHttpRequestProcessors();
    }

    public SecurityProvider getSecurityProvider() {
        List<SecurityProvider> securityProviders = this.aggregatedModule.getSecurityProviders();
        PreconditionUtil.assertEquals("exactly one security provide must be installed, got: " + securityProviders, 1, securityProviders.size());
        return securityProviders.get(0);
    }

    public ServiceDiscovery getServiceDiscovery() {
        PreconditionUtil.assertNotNull("serviceDiscovery not yet available", this.serviceDiscovery);
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void init(ObjectMapper objectMapper) {
        PreconditionUtil.assertFalse("already initialized", this.initialized);
        this.initialized = true;
        this.objectMapper = objectMapper;
        this.objectMapper.registerModules(this.getJacksonModules());
        this.applyRepositoryRegistrations(this.resourceRegistry);
        for (Module module : this.modules) {
            if (!(module instanceof InitializingModule)) continue;
            ((InitializingModule)module).init();
        }
        ExceptionMapperLookup exceptionMapperLookup = this.getExceptionMapperLookup();
        ExceptionMapperRegistryBuilder mapperRegistryBuilder = new ExceptionMapperRegistryBuilder();
        this.exceptionMapperRegistry = mapperRegistryBuilder.build(exceptionMapperLookup);
    }

    private void applyRepositoryRegistrations(ResourceRegistry resourceRegistry) {
        List<Object> repositories = this.aggregatedModule.getRepositories();
        MultivaluedMap<String, RepositoryInformation> typeInfoMapping = new MultivaluedMap<String, RepositoryInformation>();
        HashMap<Object, Object> infoRepositoryMapping = new HashMap<Object, Object>();
        this.mapRepositoryRegistrations(repositories, typeInfoMapping, infoRepositoryMapping);
        for (String resourceType : typeInfoMapping.keySet()) {
            this.applyRepositoryRegistration(resourceType, typeInfoMapping, infoRepositoryMapping);
        }
    }

    private void applyRepositoryRegistration(String resourceType, MultivaluedMap<String, RepositoryInformation> typeInfoMapping, Map<Object, Object> infoRepositoryMapping) {
        ResourceInformation resourceInformation = null;
        ResourceRepositoryInformation resourceRepositoryInformation = null;
        ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>();
        ResourceEntry resourceEntry = null;
        Class resourceClass = null;
        List<RepositoryInformation> repositoryInformations = typeInfoMapping.getList(resourceType);
        for (RepositoryInformation repositoryInformation : repositoryInformations) {
            if (repositoryInformation instanceof ResourceRepositoryInformation) {
                resourceRepositoryInformation = (ResourceRepositoryInformation)repositoryInformation;
                Object repository = infoRepositoryMapping.get(resourceRepositoryInformation);
                resourceEntry = this.setupResourceRepository(repository);
                continue;
            }
            RelationshipRepositoryInformation relationshipRepositoryInformation = (RelationshipRepositoryInformation)repositoryInformation;
            Object repository = infoRepositoryMapping.get(repositoryInformation);
            this.setupRelationship(relationshipEntries, relationshipRepositoryInformation, repository);
            if (resourceClass != null) continue;
            resourceClass = relationshipRepositoryInformation.getSourceResourceClass().get();
        }
        if (resourceRepositoryInformation != null) {
            resourceInformation = resourceRepositoryInformation.getResourceInformation().get();
        }
        if (resourceInformation == null) {
            ResourceInformationBuilder resourceInformationBuilder = this.getResourceInformationBuilder();
            PreconditionUtil.assertNotNull("resource class cannot be determined", resourceClass);
            resourceInformation = resourceInformationBuilder.build(resourceClass);
        }
        RegistryEntry registryEntry = new RegistryEntry(resourceInformation, resourceRepositoryInformation, resourceEntry, relationshipEntries);
        registryEntry.initialize(this);
        this.resourceRegistry.addEntry(registryEntry);
    }

    private void mapRepositoryRegistrations(List<Object> repositories, MultivaluedMap<String, RepositoryInformation> resourceTypeMap, Map<Object, Object> resourceInformationMap) {
        RepositoryInformationBuilder repositoryInformationBuilder = this.getRepositoryInformationBuilder();
        DefaultRepositoryInformationBuilderContext builderContext = new DefaultRepositoryInformationBuilderContext(this);
        for (Object repository : repositories) {
            RepositoryInformation info;
            if (repository instanceof ResourceRepositoryDecorator || repository instanceof RelationshipRepositoryDecorator) continue;
            RepositoryInformation repositoryInformation = repositoryInformationBuilder.build(repository, (RepositoryInformationBuilderContext)builderContext);
            if (repositoryInformation instanceof ResourceRepositoryInformation) {
                info = (ResourceRepositoryInformation)repositoryInformation;
                resourceInformationMap.put(info, repository);
                resourceTypeMap.add(info.getResourceType(), repositoryInformation);
                continue;
            }
            info = (RelationshipRepositoryInformation)repositoryInformation;
            resourceInformationMap.put(info, repository);
            resourceTypeMap.add(info.getSourceResourceType(), repositoryInformation);
        }
    }

    private ResourceEntry setupResourceRepository(Object repository) {
        final Object decoratedRepository = this.decorateRepository(repository);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, repository.getClass()){

            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        if (ClassUtils.getAnnotation(decoratedRepository.getClass(), JsonApiResourceRepository.class).isPresent()) {
            return new AnnotatedResourceEntry(repositoryInstanceBuilder);
        }
        return new DirectResponseResourceEntry(repositoryInstanceBuilder);
    }

    public Object decorateRepository(Object repository) {
        Decorator decoratedRepository = repository;
        List<RepositoryDecoratorFactory> repositoryDecorators = this.getRepositoryDecoratorFactories();
        for (RepositoryDecoratorFactory repositoryDecorator : repositoryDecorators) {
            Decorator decorator = null;
            if (decoratedRepository instanceof RelationshipRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository(decoratedRepository);
            } else if (decoratedRepository instanceof ResourceRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository((ResourceRepositoryV2)((Object)decoratedRepository));
            }
            if (decorator == null) continue;
            decorator.setDecoratedObject(decoratedRepository);
            decoratedRepository = decorator;
        }
        if (decoratedRepository instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)((Object)decoratedRepository)).setResourceRegistry(this.resourceRegistry);
        }
        return decoratedRepository;
    }

    private void setupRelationship(List<ResponseRelationshipEntry> relationshipEntries, RelationshipRepositoryInformation relationshipRepositoryInformation, Object relRepository) {
        final Object decoratedRepository = this.decorateRepository(relRepository);
        RepositoryInstanceBuilder<Object> relationshipInstanceBuilder = new RepositoryInstanceBuilder<Object>(null, relRepository.getClass()){

            @Override
            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        final String targetResourceType = relationshipRepositoryInformation.getTargetResourceType();
        if (ClassUtils.getAnnotation(relRepository.getClass(), JsonApiRelationshipRepository.class).isPresent()) {
            relationshipEntries.add(new AnnotatedRelationshipEntryBuilder(this, relationshipInstanceBuilder));
        } else {
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(relationshipInstanceBuilder){

                @Override
                public String getTargetResourceType() {
                    return targetResourceType;
                }
            };
            relationshipEntries.add(relationshipEntry);
        }
    }

    public List<DocumentFilter> getFilters() {
        return this.aggregatedModule.getFilters();
    }

    public List<RepositoryFilter> getRepositoryFilters() {
        return this.aggregatedModule.getRepositoryFilters();
    }

    public List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        return this.aggregatedModule.getRepositoryDecoratorFactories();
    }

    public ExceptionMapperLookup getExceptionMapperLookup() {
        return new CombinedExceptionMapperLookup(this.aggregatedModule.getExceptionMapperLookups());
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public <T extends Module> Optional<T> getModule(Class<T> clazz) {
        for (Module module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    public Module.ModuleContext getContext() {
        return new ModuleContextImpl();
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        PreconditionUtil.assertNotNull("exceptionMapperRegistry not set", this.exceptionMapperRegistry);
        return this.exceptionMapperRegistry;
    }

    public Map<String, ResourceRegistryPart> getRegistryParts() {
        return this.aggregatedModule.getRegistryParts();
    }

    public List<RegistryEntry> getRegistryEntries() {
        return this.aggregatedModule.getRegistryEntries();
    }

    class ModuleContextImpl
    implements Module.ModuleContext {
        ModuleContextImpl() {
        }

        @Override
        public void addResourceInformationBuilder(ResourceInformationBuilder resourceInformationBuilder) {
            ModuleRegistry.this.aggregatedModule.addResourceInformationBuilder(resourceInformationBuilder);
        }

        @Override
        public void addRepositoryInformationBuilder(RepositoryInformationBuilder repositoryInformationBuilder) {
            ModuleRegistry.this.aggregatedModule.addRepositoryInformationBuilder(repositoryInformationBuilder);
        }

        @Override
        public void addResourceLookup(ResourceLookup resourceLookup) {
            ModuleRegistry.this.aggregatedModule.addResourceLookup(resourceLookup);
        }

        @Override
        public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
            ModuleRegistry.this.aggregatedModule.addJacksonModule(module);
            if (ModuleRegistry.this.objectMapper != null) {
                ModuleRegistry.this.objectMapper.registerModule(module);
            }
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            if (ModuleRegistry.this.resourceRegistry == null) {
                throw new IllegalStateException("resourceRegistry not yet available");
            }
            return ModuleRegistry.this.resourceRegistry;
        }

        @Override
        public void addFilter(DocumentFilter filter) {
            ModuleRegistry.this.aggregatedModule.addFilter(filter);
        }

        @Override
        public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
            ModuleRegistry.this.aggregatedModule.addExceptionMapperLookup(exceptionMapperLookup);
        }

        @Override
        public void addExceptionMapper(ExceptionMapper<?> exceptionMapper) {
            ModuleRegistry.this.aggregatedModule.addExceptionMapper(exceptionMapper);
        }

        @Override
        public void addRepository(Class<?> type, Object repository) {
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addSecurityProvider(SecurityProvider securityProvider) {
            ModuleRegistry.this.aggregatedModule.addSecurityProvider(securityProvider);
        }

        @Override
        public SecurityProvider getSecurityProvider() {
            return ModuleRegistry.this.getSecurityProvider();
        }

        @Override
        public void addHttpRequestProcessor(HttpRequestProcessor processor) {
            ModuleRegistry.this.aggregatedModule.addHttpRequestProcessor(processor);
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return ModuleRegistry.this.objectMapper;
        }

        @Override
        public void addRegistryPart(String prefix, ResourceRegistryPart part) {
            ModuleRegistry.this.aggregatedModule.addRegistryPart(prefix, part);
        }

        @Override
        public ServiceDiscovery getServiceDiscovery() {
            return ModuleRegistry.this.getServiceDiscovery();
        }

        @Override
        public void addRepositoryFilter(RepositoryFilter filter) {
            ModuleRegistry.this.aggregatedModule.addRepositoryFilter(filter);
        }

        @Override
        public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decoratorFactory) {
            ModuleRegistry.this.aggregatedModule.addRepositoryDecoratorFactory(decoratorFactory);
        }

        @Override
        public void addRepository(Object repository) {
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public boolean isServer() {
            return ModuleRegistry.this.isServer;
        }

        @Override
        public TypeParser getTypeParser() {
            return ModuleRegistry.this.typeParser;
        }

        @Override
        public ResourceInformationBuilder getResourceInformationBuilder() {
            return ModuleRegistry.this.getResourceInformationBuilder();
        }

        @Override
        public ExceptionMapperRegistry getExceptionMapperRegistry() {
            return ModuleRegistry.this.getExceptionMapperRegistry();
        }

        @Override
        public RequestDispatcher getRequestDispatcher() {
            return ModuleRegistry.this.requestDispatcher;
        }

        @Override
        public RegistryEntryBuilder newRegistryEntryBuilder() {
            return new DefaultRegistryEntryBuilder(ModuleRegistry.this);
        }

        @Override
        public void addRegistryEntry(RegistryEntry entry) {
            ModuleRegistry.this.aggregatedModule.addRegistryEntry(entry);
        }
    }

    static class CombinedExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Collection<ExceptionMapperLookup> lookups;

        public CombinedExceptionMapperLookup(List<ExceptionMapperLookup> lookups) {
            this.lookups = lookups;
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            HashSet<JsonApiExceptionMapper> set = new HashSet<JsonApiExceptionMapper>();
            for (ExceptionMapperLookup lookup : this.lookups) {
                set.addAll(lookup.getExceptionMappers());
            }
            return set;
        }
    }

    static class CombinedRepositoryInformationBuilder
    implements RepositoryInformationBuilder {
        private Collection<RepositoryInformationBuilder> builders;

        public CombinedRepositoryInformationBuilder(List<RepositoryInformationBuilder> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Object repository) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Object repository, RepositoryInformationBuilderContext context) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return builder.build(repository, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationBuilder available for " + repository.getClass().getName());
        }

        @Override
        public boolean accept(Class<?> repositoryClass) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Class<?> repositoryClass, RepositoryInformationBuilderContext context) {
            for (RepositoryInformationBuilder builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return builder.build(repositoryClass, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationBuilder available for " + repositoryClass.getName());
        }
    }

    static class CombinedResourceInformationBuilder
    implements ResourceInformationBuilder {
        private Collection<ResourceInformationBuilder> builders;

        public CombinedResourceInformationBuilder(List<ResourceInformationBuilder> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResourceInformation build(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.build(resourceClass);
            }
            throw new UnsupportedOperationException("no ResourceInformationBuilder available for " + resourceClass.getName());
        }

        @Override
        public String getResourceType(Class<?> resourceClass) {
            for (ResourceInformationBuilder builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.getResourceType(resourceClass);
            }
            return null;
        }

        @Override
        public void init(ResourceInformationBuilderContext context) {
            for (ResourceInformationBuilder builder : this.builders) {
                builder.init(context);
            }
        }
    }
}

