/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.registry;

import io.crnk.core.engine.internal.utils.Predicate;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import io.crnk.legacy.registry.RepositoryEntryBuilder;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AnnotatedRepositoryEntryBuilder
implements RepositoryEntryBuilder {
    private final JsonServiceLocator jsonServiceLocator;
    private ModuleRegistry moduleRegistry;

    public AnnotatedRepositoryEntryBuilder(ModuleRegistry moduleRegistry, JsonServiceLocator jsonServiceLocator) {
        this.moduleRegistry = moduleRegistry;
        this.jsonServiceLocator = jsonServiceLocator;
    }

    @Override
    public ResourceEntry buildResourceRepository(ResourceLookup lookup, final Class<?> resourceClass) {
        Predicate classPredicate = new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> clazz) {
                return resourceClass.equals(clazz.getAnnotation(JsonApiResourceRepository.class).value());
            }
        };
        List<Class<?>> repositoryClasses = this.findRepositoryClasses(lookup, classPredicate, JsonApiResourceRepository.class);
        if (repositoryClasses.isEmpty()) {
            return null;
        }
        return new AnnotatedResourceEntry(new RepositoryInstanceBuilder(this.jsonServiceLocator, repositoryClasses.get(0)));
    }

    @Override
    public List<ResponseRelationshipEntry> buildRelationshipRepositories(ResourceLookup lookup, final Class<?> resourceClass) {
        Predicate classPredicate = new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> clazz) {
                JsonApiRelationshipRepository annotation = clazz.getAnnotation(JsonApiRelationshipRepository.class);
                return resourceClass.equals(annotation.source());
            }
        };
        List<Class<?>> repositoryClasses = this.findRepositoryClasses(lookup, classPredicate, JsonApiRelationshipRepository.class);
        ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>(repositoryClasses.size());
        for (Class<?> repositoryClass : repositoryClasses) {
            relationshipEntries.add(new AnnotatedRelationshipEntryBuilder(this.moduleRegistry, new RepositoryInstanceBuilder(this.jsonServiceLocator, repositoryClass)));
        }
        return relationshipEntries;
    }

    private List<Class<?>> findRepositoryClasses(ResourceLookup lookup, Predicate<Class<?>> classPredicate, Class<? extends Annotation> annotation) {
        LinkedList repositoryClasses = new LinkedList();
        for (Class<?> clazz : lookup.getResourceRepositoryClasses()) {
            if (!clazz.isAnnotationPresent(annotation) || !classPredicate.test(clazz)) continue;
            repositoryClasses.add(clazz);
        }
        return repositoryClasses;
    }
}

