/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.registry;

import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.registry.AnnotatedRepositoryEntryBuilder;
import io.crnk.legacy.registry.DirectRepositoryEntryBuilder;
import io.crnk.legacy.registry.RepositoryEntryBuilder;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.ResourceRepository;
import io.crnk.legacy.repository.annotations.NotFoundRepository;
import java.util.LinkedList;
import java.util.List;

public class RepositoryEntryBuilderFacade
implements RepositoryEntryBuilder {
    private final DirectRepositoryEntryBuilder directRepositoryEntryBuilder;
    private final AnnotatedRepositoryEntryBuilder annotatedRepositoryEntryBuilder;

    public RepositoryEntryBuilderFacade(ModuleRegistry moduleRegistry, JsonServiceLocator jsonServiceLocator) {
        this.directRepositoryEntryBuilder = new DirectRepositoryEntryBuilder(jsonServiceLocator);
        this.annotatedRepositoryEntryBuilder = new AnnotatedRepositoryEntryBuilder(moduleRegistry, jsonServiceLocator);
    }

    @Override
    public ResourceEntry buildResourceRepository(ResourceLookup lookup, final Class<?> resourceClass) {
        ResourceEntry resourceEntry = this.annotatedRepositoryEntryBuilder.buildResourceRepository(lookup, resourceClass);
        if (resourceEntry == null) {
            resourceEntry = this.directRepositoryEntryBuilder.buildResourceRepository(lookup, resourceClass);
        }
        if (resourceEntry == null) {
            RepositoryInstanceBuilder<ResourceRepository> repositoryInstanceBuilder = new RepositoryInstanceBuilder<ResourceRepository>(new JsonServiceLocator(){

                @Override
                public <T> T getInstance(Class<T> clazz) {
                    return (T)new NotFoundRepository(resourceClass);
                }
            }, NotFoundRepository.class);
            resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        }
        return resourceEntry;
    }

    @Override
    public List<ResponseRelationshipEntry> buildRelationshipRepositories(ResourceLookup lookup, Class<?> resourceClass) {
        List<ResponseRelationshipEntry> annotationEntries = this.annotatedRepositoryEntryBuilder.buildRelationshipRepositories(lookup, resourceClass);
        LinkedList<ResponseRelationshipEntry> targetEntries = new LinkedList<ResponseRelationshipEntry>(annotationEntries);
        List<ResponseRelationshipEntry> directEntries = this.directRepositoryEntryBuilder.buildRelationshipRepositories(lookup, resourceClass);
        for (ResponseRelationshipEntry directEntry : directEntries) {
            if (this.contains(targetEntries, directEntry)) continue;
            targetEntries.add(directEntry);
        }
        return targetEntries;
    }

    private boolean contains(List<ResponseRelationshipEntry> targetEntries, ResponseRelationshipEntry directEntry) {
        boolean contains = false;
        for (ResponseRelationshipEntry targetEntry : targetEntries) {
            if (!targetEntry.getTargetResourceType().equals(directEntry.getTargetResourceType())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

