/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceAttributesBridge;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.exception.MultipleJsonApiLinksInformationException;
import io.crnk.core.exception.MultipleJsonApiMetaInformationException;
import io.crnk.core.exception.ResourceDuplicateIdException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceInformation {
    private final Class<?> resourceClass;
    private ResourceField idField;
    private ResourceAttributesBridge attributeFields;
    private List<ResourceField> relationshipFields;
    private ResourceField metaField;
    private ResourceField linksField;
    private final String resourceType;
    private ResourceInstanceBuilder<?> instanceBuilder;
    private final TypeParser parser;
    private String superResourceType;
    private Map<String, ResourceField> fieldByJsonName = new HashMap<String, ResourceField>();
    private Map<String, ResourceField> fieldByUnderlyingName = new HashMap<String, ResourceField>();
    private List<ResourceField> fields;

    public ResourceInformation(TypeParser parser, Class<?> resourceClass, String resourceType, String superResourceType, List<ResourceField> fields) {
        this(parser, resourceClass, resourceType, superResourceType, null, fields);
    }

    public ResourceInformation(TypeParser parser, Class<?> resourceClass, String resourceType, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields) {
        this.parser = parser;
        this.resourceClass = resourceClass;
        this.resourceType = resourceType;
        this.superResourceType = superResourceType;
        this.instanceBuilder = instanceBuilder;
        this.fields = fields;
        this.initFields();
        if (this.instanceBuilder == null) {
            this.instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        }
    }

    private void initFields() {
        if (this.fields != null) {
            List<ResourceField> idFields = ResourceFieldType.ID.filter(this.fields);
            if (idFields.size() > 1) {
                throw new ResourceDuplicateIdException(this.resourceClass.getCanonicalName());
            }
            this.idField = idFields.isEmpty() ? null : idFields.get(0);
            this.attributeFields = new ResourceAttributesBridge(ResourceFieldType.ATTRIBUTE.filter(this.fields), this.resourceClass);
            this.relationshipFields = ResourceFieldType.RELATIONSHIP.filter(this.fields);
            this.metaField = ResourceInformation.getMetaField(this.resourceClass, this.fields);
            this.linksField = ResourceInformation.getLinksField(this.resourceClass, this.fields);
            for (ResourceField resourceField : this.fields) {
                resourceField.setResourceInformation(this);
                this.fieldByJsonName.put(resourceField.getJsonName(), resourceField);
                this.fieldByUnderlyingName.put(resourceField.getUnderlyingName(), resourceField);
            }
        } else {
            this.relationshipFields = Collections.emptyList();
            this.attributeFields = new ResourceAttributesBridge(Collections.emptyList(), this.resourceClass);
            this.metaField = null;
            this.linksField = null;
            this.idField = null;
        }
    }

    @Deprecated
    public void setFields(List<ResourceField> fields) {
        this.fields = fields;
        this.initFields();
    }

    private static <T> ResourceField getMetaField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> metaFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.META_INFORMATION) continue;
            metaFields.add(field);
        }
        if (metaFields.isEmpty()) {
            return null;
        }
        if (metaFields.size() > 1) {
            throw new MultipleJsonApiMetaInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)metaFields.get(0);
    }

    private static <T> ResourceField getLinksField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> linksFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.LINKS_INFORMATION) continue;
            linksFields.add(field);
        }
        if (linksFields.isEmpty()) {
            return null;
        }
        if (linksFields.size() > 1) {
            throw new MultipleJsonApiLinksInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)linksFields.get(0);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getSuperResourceType() {
        return this.superResourceType;
    }

    public <T> ResourceInstanceBuilder<T> getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ResourceField getIdField() {
        return this.idField;
    }

    public ResourceAttributesBridge getAttributeFields() {
        return this.attributeFields;
    }

    public List<ResourceField> getRelationshipFields() {
        return this.relationshipFields;
    }

    public ResourceField findFieldByName(String name) {
        return this.fieldByJsonName.get(name);
    }

    public ResourceField findFieldByUnderlyingName(String name) {
        return this.fieldByUnderlyingName.get(name);
    }

    public ResourceField findRelationshipFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP ? resourceField : null;
    }

    public ResourceField findAttributeFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.ATTRIBUTE ? resourceField : null;
    }

    public ResourceField getMetaField() {
        return this.metaField;
    }

    public ResourceField getLinksField() {
        return this.linksField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInformation that = (ResourceInformation)o;
        return Objects.equals(this.resourceClass, that.resourceClass) && Objects.equals(this.resourceType, that.resourceType);
    }

    public int hashCode() {
        return Objects.hash(this.resourceClass, this.resourceType);
    }

    public String toIdString(Object id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public Serializable parseIdString(String id) {
        Class<?> idType = this.getIdField().getType();
        return this.parser.parse(id, idType);
    }

    public Object getId(Object resource) {
        return this.idField.getAccessor().getValue(resource);
    }

    public void setId(Object resource, Object id) {
        this.idField.getAccessor().setValue(resource, id);
    }

    public void verify(Object resource, Document requestDocument) {
    }

    public List<ResourceField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }
}

